/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.junit4.internal;

import java.lang.reflect.Method;
import java.util.List;
import mockit.Instantiation;
import mockit.Mock;
import mockit.MockClass;
import mockit.integration.TestRunnerDecorator;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.state.SavePoint;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MockClass(realClass=FrameworkMethod.class, instantiation=Instantiation.PerMockedInstance)
public final class JUnit4TestRunnerDecorator
extends TestRunnerDecorator {
    public FrameworkMethod it;
    private static volatile boolean shouldPrepareForNextTest = true;

    @Mock(reentrant=true)
    public Object invokeExplosively(Object target, Object ... params) throws Throwable {
        Method method = this.it.getMethod();
        Class<?> testClass = target == null ? method.getDeclaringClass() : target.getClass();
        this.handleMockingOutsideTestMethods(target, testClass);
        if (this.it.getAnnotation(Test.class) == null) {
            if (shouldPrepareForNextTest && this.it.getAnnotation(Before.class) != null) {
                this.prepareForNextTest();
                shouldPrepareForNextTest = false;
            }
            TestRun.setRunningIndividualTest(target);
            TestRun.setRunningTestMethod(null);
            try {
                Object object = this.it.invokeExplosively(target, params);
                return object;
            }
            catch (Throwable t) {
                RecordAndReplayExecution.endCurrentReplayIfAny();
                Utilities.filterStackTrace(t);
                throw t;
            }
            finally {
                if (this.it.getAnnotation(After.class) != null) {
                    TestRun.getExecutingTest().setRecordAndReplay(null);
                }
            }
        }
        if (shouldPrepareForNextTest) {
            this.prepareForNextTest();
        }
        shouldPrepareForNextTest = true;
        TestRun.setRunningTestMethod(method);
        try {
            this.executeTestMethod(target, params);
            Object t = null;
            return t;
        }
        catch (Throwable t) {
            Utilities.filterStackTrace(t);
            throw t;
        }
        finally {
            TestRun.finishCurrentTestExecution(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMockingOutsideTestMethods(Object target, Class<?> testClass) {
        TestRun.enterNoMockingZone();
        try {
            if (testClass.isAnnotationPresent(Suite.SuiteClasses.class)) {
                this.setUpClassLevelMocksAndStubs(testClass);
            } else {
                this.updateTestClassState(target, testClass);
            }
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTestMethod(Object target, Object ... parameters) throws Throwable {
        SavePoint savePoint = new SavePoint();
        try {
            this.createInstancesForTestedFields(target);
            Object[] mockParameters = this.createInstancesForMockParameters(target, this.it.getMethod());
            TestRun.setRunningIndividualTest(target);
            this.it.invokeExplosively(target, mockParameters == null ? parameters : mockParameters);
        }
        finally {
            this.concludeTestMethodExecution(savePoint);
        }
    }

    @Mock(reentrant=true)
    public void validatePublicVoidNoArg(boolean isStatic, List<Throwable> errors) {
        if (!isStatic && this.it.getMethod().getParameterTypes().length > 0) {
            this.it.validatePublicVoid(false, errors);
            return;
        }
        this.it.validatePublicVoidNoArg(isStatic, errors);
    }
}

