/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.junit4.internal;

import mockit.Instantiation;
import mockit.Mock;
import mockit.MockClass;
import mockit.integration.TestRunnerDecorator;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MockClass(realClass=RunNotifier.class, instantiation=Instantiation.PerMockedInstance)
public final class RunNotifierDecorator {
    public RunNotifier it;

    @Mock(reentrant=true)
    public void fireTestStarted(Description description) {
        String testClassName;
        Class<?> currentTestClass = TestRun.getCurrentTestClass();
        if (currentTestClass != null && !(testClassName = this.getTestClassName(description)).equals(currentTestClass.getName())) {
            Class testClass = Utilities.loadClass(testClassName);
            this.discardCurrentTestClassIfNoLongerValid(testClass);
        }
        this.it.fireTestStarted(description);
    }

    private String getTestClassName(Description description) {
        String testClassName = description.getDisplayName();
        int p = testClassName.indexOf(40);
        return testClassName.substring(p + 1, testClassName.length() - 1);
    }

    private void discardCurrentTestClassIfNoLongerValid(Class<?> testClass) {
        Class<?> currentTestClass = TestRun.getCurrentTestClass();
        if (!currentTestClass.isAssignableFrom(testClass)) {
            TestRunnerDecorator.cleanUpMocksFromPreviousTestClass();
            TestRun.setCurrentTestClass(null);
        }
    }
}

