/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.testng.internal;

import java.lang.reflect.Method;
import mockit.Mock;
import mockit.MockClass;
import mockit.Mockit;
import mockit.integration.TestRunnerDecorator;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.state.SavePoint;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;
import org.testng.IConfigurable;
import org.testng.IConfigureCallBack;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public final class TestNGRunnerDecorator
extends TestRunnerDecorator
implements IConfigurable,
IHookable {
    private final ThreadLocal<SavePoint> savePoint = new ThreadLocal();
    private boolean shouldPrepareForNextTest;

    private static boolean isMethodWithParametersProvidedByTestNG(Method method) {
        if (method.isAnnotationPresent(Parameters.class)) {
            return true;
        }
        Test testMetadata = method.getAnnotation(Test.class);
        return testMetadata != null && testMetadata.dataProvider().length() > 0;
    }

    public TestNGRunnerDecorator() {
        Mockit.setUpMocks(MockParameters.class);
        this.shouldPrepareForNextTest = true;
    }

    public void run(IConfigureCallBack callBack, ITestResult testResult) {
        Object testInstance = testResult.getInstance();
        Class testClass = testResult.getTestClass().getRealClass();
        this.updateTestClassState(testInstance, testClass);
        if (this.shouldPrepareForNextTest && testResult.getMethod().isBeforeMethodConfiguration()) {
            this.prepareForNextTest();
            this.shouldPrepareForNextTest = false;
        }
        TestRun.setRunningIndividualTest(testInstance);
        TestRun.setRunningTestMethod(null);
        try {
            callBack.runConfigurationMethod(testResult);
        }
        catch (RuntimeException t) {
            RecordAndReplayExecution.endCurrentReplayIfAny();
            Utilities.filterStackTrace(t);
            throw t;
        }
        finally {
            if (testResult.getMethod().isAfterMethodConfiguration()) {
                TestRun.getExecutingTest().setRecordAndReplay(null);
            }
        }
    }

    public void run(IHookCallBack callBack, ITestResult testResult) {
        Object testInstance = testResult.getInstance();
        Class testClass = testResult.getTestClass().getRealClass();
        this.updateTestClassState(testInstance, testClass);
        this.savePoint.set(new SavePoint());
        if (this.shouldPrepareForNextTest) {
            this.prepareForNextTest();
        }
        this.shouldPrepareForNextTest = true;
        this.createInstancesForTestedFields(testInstance);
        Method method = testResult.getMethod().getMethod();
        if (!TestNGRunnerDecorator.isMethodWithParametersProvidedByTestNG(method)) {
            Object[] parameters = testResult.getParameters();
            Object[] mockParameters = this.createInstancesForMockParameters(testInstance, method);
            if (mockParameters != null) {
                System.arraycopy(mockParameters, 0, parameters, 0, parameters.length);
            }
        }
        TestRun.setRunningIndividualTest(testInstance);
        TestRun.setRunningTestMethod(method);
        try {
            this.executeTestMethod(callBack, testResult);
        }
        catch (AssertionError t) {
            Utilities.filterStackTrace((Throwable)((Object)t));
            throw t;
        }
        finally {
            TestRun.finishCurrentTestExecution(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTestMethod(IHookCallBack callBack, ITestResult testResult) {
        try {
            callBack.runTestMethod(testResult);
            Throwable thrown = testResult.getThrowable();
            if (thrown != null) {
                Utilities.filterStackTrace(thrown);
            }
        }
        finally {
            SavePoint testMethodSavePoint = this.savePoint.get();
            this.savePoint.set(null);
            this.concludeTestMethodExecution(testMethodSavePoint);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @MockClass(realClass=org.testng.internal.Parameters.class, stubs={"checkParameterTypes"})
    public static final class MockParameters {
        @Mock(reentrant=true)
        public static Object getInjectedParameter(Class<?> c, Method method, ITestContext context, ITestResult testResult) {
            Object value = org.testng.internal.Parameters.getInjectedParameter(c, (Method)method, (ITestContext)context, (ITestResult)testResult);
            if (value != null) {
                return value;
            }
            return method == null || TestNGRunnerDecorator.isMethodWithParametersProvidedByTestNG(method) ? null : "";
        }
    }
}

