/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal;

import java.lang.reflect.Modifier;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassWriter;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.Type;
import mockit.internal.state.TestRun;

public class BaseClassModifier
extends ClassWriter {
    private static final int ACCESS_MASK = 64255;
    private static final String[] PRIMITIVE_WRAPPER_TYPE = new String[]{null, "java/lang/Boolean", "java/lang/Character", "java/lang/Byte", "java/lang/Short", "java/lang/Integer", "java/lang/Float", "java/lang/Long", "java/lang/Double"};
    private static final String[] UNBOXING_METHOD = new String[]{null, "booleanValue", "charValue", "byteValue", "shortValue", "intValue", "floatValue", "longValue", "doubleValue"};
    private static final Type[] NO_ARGS = new Type[0];
    protected MethodVisitor mw;
    protected boolean useMockingBridge;
    private String modifiedClassName;

    protected BaseClassModifier(ClassReader classReader) {
        super(classReader, true);
    }

    protected final void setUseMockingBridge(ClassLoader classLoader) {
        this.useMockingBridge = classLoader == null;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        int modifiedVersion = version;
        int originalVersion = version & 0xFFFF;
        if (originalVersion < 49) {
            modifiedVersion = 49;
        } else if (originalVersion == 51) {
            modifiedVersion = 50;
        }
        super.visit(modifiedVersion, access, name, signature, superName, interfaces);
        this.modifiedClassName = name;
    }

    protected final void startModifiedMethodVersion(int access, String name, String desc, String signature, String[] exceptions) {
        this.mw = super.visitMethod(access & 0xFAFF, name, desc, signature, exceptions);
        if (Modifier.isNative(access)) {
            TestRun.mockFixture().addRedefinedClassWithNativeMethods(this.modifiedClassName);
        }
    }

    private boolean generateCodeToPassThisOrNullIfStaticMethod(int access) {
        boolean isStatic = Modifier.isStatic(access);
        this.generateCodeToPassThisOrNullIfStaticMethod(isStatic);
        return isStatic;
    }

    protected final void generateCodeToPassThisOrNullIfStaticMethod(boolean isStatic) {
        if (isStatic) {
            this.mw.visitInsn(1);
        } else {
            this.mw.visitVarInsn(25, 0);
        }
    }

    protected final void generateCodeToPassMethodArgumentsAsVarargs(boolean isStatic, Type[] argTypes) {
        this.generateCodeToCreateArrayOfObject(argTypes.length);
        this.generateCodeToPassMethodArgumentsAsVarargs(argTypes, 0, isStatic ? 0 : 1);
    }

    private void generateCodeToCreateArrayOfObject(int arrayLength) {
        this.mw.visitIntInsn(16, arrayLength);
        this.mw.visitTypeInsn(189, "java/lang/Object");
    }

    private void generateCodeToPassMethodArgumentsAsVarargs(Type[] argTypes, int initialArrayIndex, int initialParameterIndex) {
        int i = initialArrayIndex;
        int j = initialParameterIndex;
        for (Type argType : argTypes) {
            this.mw.visitInsn(89);
            this.mw.visitIntInsn(16, i++);
            this.mw.visitVarInsn(argType.getOpcode(21), j);
            int sort = argType.getSort();
            if (sort < 9) {
                String wrapperType = PRIMITIVE_WRAPPER_TYPE[sort];
                this.mw.visitMethodInsn(184, wrapperType, "valueOf", "(" + argType + ")L" + wrapperType + ';');
            }
            this.mw.visitInsn(83);
            j += argType.getSize();
        }
    }

    protected final void generateReturnWithObjectAtTopOfTheStack(String methodDesc) {
        Type returnType = Type.getReturnType(methodDesc);
        int sort = returnType.getSort();
        if (sort == 0) {
            this.mw.visitInsn(87);
        } else if (sort == 9) {
            this.mw.visitTypeInsn(192, returnType.getDescriptor());
        } else if (sort == 10) {
            this.mw.visitTypeInsn(192, returnType.getInternalName());
        } else {
            String returnDesc = PRIMITIVE_WRAPPER_TYPE[sort];
            this.mw.visitTypeInsn(192, returnDesc);
            this.mw.visitMethodInsn(182, returnDesc, UNBOXING_METHOD[sort], "()" + returnType);
        }
        this.mw.visitInsn(returnType.getOpcode(172));
    }

    protected final void generateDirectCallToHandler(String className, int access, String name, String desc, String genericSignature, String[] exceptions, int executionMode) {
        boolean isStatic = this.generateCodeToPassThisOrNullIfStaticMethod(access);
        this.mw.visitLdcInsn(access);
        this.mw.visitLdcInsn(className);
        this.mw.visitLdcInsn(name + desc);
        this.generateInstructionToLoadNullableString(genericSignature);
        String exceptionsStr = this.getListOfExceptionsAsSingleString(exceptions);
        this.generateInstructionToLoadNullableString(exceptionsStr);
        this.mw.visitLdcInsn(executionMode);
        Type[] argTypes = Type.getArgumentTypes(desc);
        this.generateCodeToPassMethodArgumentsAsVarargs(isStatic, argTypes);
        this.mw.visitMethodInsn(184, "mockit/internal/expectations/RecordAndReplayExecution", "recordOrReplay", "(Ljava/lang/Object;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I[Ljava/lang/Object;)Ljava/lang/Object;");
    }

    private void generateInstructionToLoadNullableString(String text) {
        if (text == null) {
            this.mw.visitInsn(1);
        } else {
            this.mw.visitLdcInsn(text);
        }
    }

    private String getListOfExceptionsAsSingleString(String[] exceptions) {
        if (exceptions == null) {
            return null;
        }
        if (exceptions.length == 1) {
            return exceptions[0];
        }
        StringBuilder buf = new StringBuilder(200);
        String sep = "";
        for (String exception : exceptions) {
            buf.append(sep).append(exception);
            sep = " ";
        }
        return buf.toString();
    }

    protected final void generateCallToMockingBridge(int targetId, String mockClassName, int mockAccess, String mockName, String mockDesc, String targetMockDesc, String genericSignature, String[] exceptions, int mockStateIndex, int mockInstanceIndex, int executionMode) {
        this.generateCodeToObtainInstanceOfMockingBridge();
        boolean isStatic = this.generateCodeToPassThisOrNullIfStaticMethod(mockAccess);
        this.mw.visitInsn(1);
        Type[] argTypes = mockDesc == null ? NO_ARGS : Type.getArgumentTypes(mockDesc);
        this.generateCodeToCreateArrayOfObject(10 + argTypes.length);
        int i = 0;
        this.generateCodeToFillArrayElement(i++, targetId);
        this.generateCodeToFillArrayElement(i++, mockAccess);
        this.generateCodeToFillArrayElement(i++, mockClassName);
        this.generateCodeToFillArrayElement(i++, mockName);
        this.generateCodeToFillArrayElement(i++, targetMockDesc);
        this.generateCodeToFillArrayElement(i++, genericSignature);
        this.generateCodeToFillArrayElement(i++, this.getListOfExceptionsAsSingleString(exceptions));
        this.generateCodeToFillArrayElement(i++, mockStateIndex);
        this.generateCodeToFillArrayElement(i++, mockInstanceIndex);
        this.generateCodeToFillArrayElement(i++, executionMode);
        this.generateCodeToPassMethodArgumentsAsVarargs(argTypes, i, isStatic ? 0 : 1);
        this.generateCallToMockingBridge();
    }

    protected final void generateCodeToObtainInstanceOfMockingBridge() {
        this.mw.visitLdcInsn("mockit.internal.MockingBridge");
        this.mw.visitInsn(4);
        this.mw.visitMethodInsn(184, "java/lang/ClassLoader", "getSystemClassLoader", "()Ljava/lang/ClassLoader;");
        this.mw.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;");
        this.mw.visitLdcInsn("MB");
        this.mw.visitMethodInsn(182, "java/lang/Class", "getField", "(Ljava/lang/String;)Ljava/lang/reflect/Field;");
        this.mw.visitInsn(1);
        this.mw.visitMethodInsn(182, "java/lang/reflect/Field", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
    }

    private void generateCodeToFillArrayElement(int arrayIndex, Object value) {
        this.mw.visitInsn(89);
        this.mw.visitIntInsn(16, arrayIndex);
        if (value == null) {
            this.mw.visitInsn(1);
        } else if (value instanceof Integer) {
            this.mw.visitIntInsn(17, (Integer)value);
            this.mw.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        } else {
            this.mw.visitLdcInsn(value);
        }
        this.mw.visitInsn(83);
    }

    protected final void generateCallToMockingBridge() {
        this.mw.visitMethodInsn(185, "java/lang/reflect/InvocationHandler", "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;");
    }

    private void pushDefaultValuesForParameterTypes(Type[] paramTypes) {
        for (Type paramType : paramTypes) {
            this.pushDefaultValueForType(paramType);
        }
    }

    protected final void pushDefaultValuesForParameterTypes(String methodOrConstructorDesc) {
        if (!"()V".equals(methodOrConstructorDesc)) {
            this.pushDefaultValuesForParameterTypes(Type.getArgumentTypes(methodOrConstructorDesc));
        }
    }

    protected final void pushDefaultValueForType(Type type) {
        switch (type.getSort()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.mw.visitInsn(3);
                break;
            }
            case 7: {
                this.mw.visitInsn(9);
                break;
            }
            case 6: {
                this.mw.visitInsn(11);
                break;
            }
            case 8: {
                this.mw.visitInsn(14);
                break;
            }
            case 9: {
                this.generateCreationOfEmptyArray(type);
                break;
            }
            default: {
                this.mw.visitInsn(1);
            }
        }
    }

    private void generateCreationOfEmptyArray(Type arrayType) {
        int dimensions = arrayType.getDimensions();
        for (int dimension = 0; dimension < dimensions; ++dimension) {
            this.mw.visitInsn(3);
        }
        if (dimensions > 1) {
            this.mw.visitMultiANewArrayInsn(arrayType.getDescriptor(), dimensions);
            return;
        }
        Type elementType = arrayType.getElementType();
        int elementSort = elementType.getSort();
        if (elementSort == 10) {
            this.mw.visitTypeInsn(189, elementType.getInternalName());
        } else {
            int typ = this.getArrayElementTypeCode(elementSort);
            this.mw.visitIntInsn(188, typ);
        }
    }

    private int getArrayElementTypeCode(int elementSort) {
        switch (elementSort) {
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 9;
            }
            case 5: {
                return 10;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 11;
            }
        }
        return 7;
    }

    protected final void generateEmptyImplementation(String desc) {
        Type returnType = Type.getReturnType(desc);
        this.pushDefaultValueForType(returnType);
        this.mw.visitInsn(returnType.getOpcode(172));
        this.mw.visitMaxs(1, 0);
    }

    protected final void generateEmptyImplementation() {
        this.mw.visitInsn(177);
        this.mw.visitMaxs(1, 0);
    }

    protected final boolean isMethodFromObject(String name, String desc) {
        return "equals".equals(name) && "(Ljava/lang/Object;)Z".equals(desc) || "hashCode".equals(name) && "()I".equals(desc) || "toString".equals(name) && "()Ljava/lang/String;".equals(desc) || "finalize".equals(name) && "()V".equals(desc);
    }
}

