/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import mockit.Invocation;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MockingBridge
implements InvocationHandler {
    public static final int RECORD_OR_REPLAY = 1;
    public static final int CALL_STATIC_MOCK = 3;
    public static final int CALL_INSTANCE_MOCK = 4;
    public static final int UPDATE_MOCK_STATE = 5;
    public static final int EXIT_REENTRANT_MOCK = 6;
    private static final Object[] EMPTY_ARGS = new Object[0];
    public static final MockingBridge MB = new MockingBridge();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object mocked, Method method, Object[] args) throws Throwable {
        int targetId = (Integer)args[0];
        if (mocked != null && MockingBridge.instanceOfClassThatParticipatesInClassLoading(mocked) && MockingBridge.wasCalledDuringClassLoading()) {
            return targetId == 5 ? Boolean.valueOf(false) : Void.class;
        }
        String mockClassDesc = (String)args[2];
        int mockStateIndex = (Integer)args[7];
        if (targetId == 5) {
            return TestRun.updateMockState(mockClassDesc, mockStateIndex);
        }
        if (targetId == 6) {
            TestRun.exitReentrantMock(mockClassDesc, mockStateIndex);
            return null;
        }
        String mockName = (String)args[3];
        String mockDesc = (String)args[4];
        Object[] mockArgs = MockingBridge.extractMockArguments(args);
        if (targetId != 1) {
            int mockIndex = (Integer)args[8];
            return MockingBridge.callMock(mocked, targetId, mockClassDesc, mockName, mockDesc, mockStateIndex, mockIndex, mockArgs);
        }
        if (TestRun.isInsideNoMockingZone()) {
            return Void.class;
        }
        TestRun.enterNoMockingZone();
        try {
            int mockAccess = (Integer)args[1];
            String genericSignature = (String)args[5];
            String exceptions = (String)args[6];
            int executionMode = (Integer)args[9];
            Object object = RecordAndReplayExecution.recordOrReplay(mocked, mockAccess, mockClassDesc, mockName + mockDesc, genericSignature, exceptions, executionMode, mockArgs);
            return object;
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }

    private static boolean instanceOfClassThatParticipatesInClassLoading(Object mocked) {
        Class<?> mockedClass = mocked.getClass();
        return mockedClass == File.class || mockedClass == URL.class || mockedClass == FileInputStream.class || Vector.class.isInstance(mocked) || Hashtable.class.isInstance(mocked);
    }

    private static boolean wasCalledDuringClassLoading() {
        StackTraceElement[] st = new Throwable().getStackTrace();
        for (int i = 3; i < st.length; ++i) {
            StackTraceElement ste = st[i];
            if (!"ClassLoader.java".equals(ste.getFileName()) || !"loadClass".equals(ste.getMethodName())) continue;
            return true;
        }
        return false;
    }

    private static Object[] extractMockArguments(Object[] args) {
        int i = 10;
        if (args.length > i) {
            Object[] mockArgs = new Object[args.length - i];
            System.arraycopy(args, i, mockArgs, 0, mockArgs.length);
            return mockArgs;
        }
        return EMPTY_ARGS;
    }

    private static Object callMock(Object mocked, int targetId, String mockClassInternalName, String mockName, String mockDesc, int mockStateIndex, int mockInstanceIndex, Object[] mockArgs) {
        Class<Object> mockClass;
        String mockClassName;
        Object mock;
        if (targetId == 3) {
            mock = mocked;
            mockClassName = MockingBridge.getMockClassName(mockClassInternalName);
            mockClass = Utilities.loadClass(mockClassName);
        } else {
            assert (targetId == 4);
            if (mockInstanceIndex < 0) {
                mockClassName = MockingBridge.getMockClassName(mockClassInternalName);
                mock = Utilities.newInstance(mockClassName, new Object[0]);
            } else {
                mock = TestRun.getMock(mockInstanceIndex);
            }
            mockClass = mock.getClass();
            MockingBridge.setItFieldIfAny(mockClass, mock, mocked);
        }
        Class<?>[] paramClasses = Utilities.getParameterTypes(mockDesc);
        if (paramClasses.length > 0 && paramClasses[0] == Invocation.class) {
            Invocation invocation = TestRun.createMockInvocation(mockClassInternalName, mockStateIndex, mocked);
            mockArgs = Utilities.argumentsWithExtraFirstValue(mockArgs, invocation);
        }
        Object result = Utilities.invoke(mockClass, mock, mockName, paramClasses, mockArgs);
        return result;
    }

    private static String getMockClassName(String mockClassInternalName) {
        return mockClassInternalName.replace('/', '.');
    }

    private static void setItFieldIfAny(Class<?> mockClass, Object mock, Object mocked) {
        try {
            Field itField = mockClass.getDeclaredField("it");
            Utilities.setFieldValue(itField, mock, mocked);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }
}

