/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.UnmodifiableClassException;
import java.util.List;
import java.util.Map;
import mockit.Instantiation;
import mockit.MockClass;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassWriter;
import mockit.internal.ClassFile;
import mockit.internal.StubOutModifier;
import mockit.internal.annotations.AnnotatedMockMethodCollector;
import mockit.internal.annotations.AnnotatedMockMethods;
import mockit.internal.annotations.AnnotationsModifier;
import mockit.internal.filtering.MockingConfiguration;
import mockit.internal.startup.Startup;
import mockit.internal.state.MockFixture;
import mockit.internal.state.TestRun;
import mockit.internal.util.MethodFormatter;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RedefinitionEngine {
    private Class<?> realClass;
    private final Class<?> mockClass;
    private final Instantiation instantiation;
    private final MockingConfiguration mockingConfiguration;
    private final AnnotatedMockMethods mockMethods;
    private Object mock;

    public RedefinitionEngine() {
        this(null, null, null, null);
    }

    public RedefinitionEngine(Class<?> realOrMockClass) {
        MockClass metadata = realOrMockClass.getAnnotation(MockClass.class);
        if (metadata == null) {
            this.realClass = realOrMockClass;
            this.mockClass = null;
            this.instantiation = Instantiation.PerMockInvocation;
            this.mockingConfiguration = null;
            this.mockMethods = null;
        } else {
            this.realClass = metadata.realClass();
            this.mockClass = realOrMockClass;
            this.instantiation = metadata.instantiation();
            this.mockingConfiguration = this.createMockingConfiguration(metadata);
            this.mockMethods = new AnnotatedMockMethods(this.realClass);
            new AnnotatedMockMethodCollector(this.mockMethods).collectMockMethods(this.mockClass);
            this.createMockInstanceAccordingToInstantiation();
        }
    }

    private MockingConfiguration createMockingConfiguration(MockClass metadata) {
        return this.createMockingConfiguration(metadata.stubs(), !metadata.inverse());
    }

    private MockingConfiguration createMockingConfiguration(String[] filters, boolean notInverted) {
        return filters.length == 0 ? null : new MockingConfiguration(filters, notInverted);
    }

    private void createMockInstanceAccordingToInstantiation() {
        if (this.mock == null && this.instantiation == Instantiation.PerMockSetup) {
            this.mock = Utilities.newInstance(this.mockClass);
        }
    }

    public RedefinitionEngine(Class<?> realClass, boolean filtersNotInverted, String[] stubbingFilters) {
        this.realClass = realClass;
        this.mockClass = null;
        this.instantiation = Instantiation.PerMockInvocation;
        this.mockMethods = null;
        this.mockingConfiguration = this.createMockingConfiguration(stubbingFilters, filtersNotInverted);
    }

    public RedefinitionEngine(Class<?> realClass, Object mock, Class<?> mockClass) {
        this(realClass, mockClass, mock, new AnnotatedMockMethods(realClass));
        new AnnotatedMockMethodCollector(this.mockMethods).collectMockMethods(mockClass);
    }

    public RedefinitionEngine(Class<?> realClass, Class<?> mockClass, Object mock, AnnotatedMockMethods mockMethods) {
        this.realClass = realClass;
        this.mockClass = mockClass;
        this.mock = mock;
        this.mockMethods = mockMethods;
        if (mockClass == null || !mockClass.isAnnotationPresent(MockClass.class)) {
            this.instantiation = Instantiation.PerMockInvocation;
            this.mockingConfiguration = null;
        } else {
            MockClass metadata = mockClass.getAnnotation(MockClass.class);
            this.instantiation = metadata.instantiation();
            this.createMockInstanceAccordingToInstantiation();
            this.mockingConfiguration = this.createMockingConfiguration(metadata);
        }
    }

    public RedefinitionEngine(Object mock, Class<?> mockClass) {
        this(RedefinitionEngine.getRealClass(mockClass), mock, mockClass);
    }

    private static Class<?> getRealClass(Class<?> specifiedMockClass) {
        MockClass mockClassAnnotation = specifiedMockClass.getAnnotation(MockClass.class);
        if (mockClassAnnotation == null) {
            throw new IllegalArgumentException("Missing @MockClass for " + specifiedMockClass);
        }
        return mockClassAnnotation.realClass();
    }

    public boolean isWithMockClass() {
        return this.mockClass != null;
    }

    public Class<?> getRealClass() {
        return this.realClass;
    }

    public void setRealClass(Class<?> realClass) {
        this.realClass = realClass;
    }

    public void setUpStartupMock() {
        if (this.realClass != null) {
            this.redefineMethods(true);
        }
    }

    public void stubOut() {
        ClassReader rcReader = this.createClassReaderForRealClass();
        StubOutModifier rcWriter = new StubOutModifier(rcReader, this.mockingConfiguration);
        rcReader.accept(rcWriter, false);
        byte[] modifiedClassFile = rcWriter.toByteArray();
        String classDesc = this.realClass.getName().replace('.', '/');
        this.redefineMethods(classDesc, modifiedClassFile, true);
    }

    public void redefineMethods() {
        this.redefineMethods(false);
    }

    private void redefineMethods(boolean forStartupMock) {
        if (this.mockMethods.getMethodCount() > 0 || this.mockingConfiguration != null) {
            byte[] modifiedClassFile = this.modifyRealClass(forStartupMock);
            this.redefineMethods(this.mockMethods.getMockClassInternalName(), modifiedClassFile, !forStartupMock);
        }
    }

    private byte[] modifyRealClass(boolean forStartupMock) {
        ClassReader rcReader = this.createClassReaderForRealClass();
        AnnotationsModifier modifier = new AnnotationsModifier(rcReader, this.realClass, this.mock, this.mockMethods, this.mockingConfiguration, forStartupMock);
        if (this.mock == null && this.instantiation == Instantiation.PerMockedInstance) {
            modifier.useOneMockInstancePerMockedInstance(this.mockClass);
        }
        return this.modifyRealClass(rcReader, modifier, this.mockClass.getName());
    }

    private ClassReader createClassReaderForRealClass() {
        if (this.realClass.isInterface() || this.realClass.isArray()) {
            throw new IllegalArgumentException("Not a modifiable class: " + this.realClass.getName());
        }
        return new ClassFile(this.realClass, true).getReader();
    }

    public byte[] modifyRealClass(ClassReader rcReader, ClassWriter rcWriter, String mockClassName) {
        rcReader.accept(rcWriter, false);
        if (this.mockMethods.getMethodCount() > 0) {
            List<String> remainingMocks = this.mockMethods.getMethods();
            String mockSignatures = new MethodFormatter().friendlyMethodSignatures(remainingMocks);
            throw new IllegalArgumentException("Matching real methods not found for the following mocks of " + mockClassName + ":\n" + mockSignatures);
        }
        return rcWriter.toByteArray();
    }

    public static void redefineClasses(ClassDefinition ... definitions) {
        RedefinitionEngine.redefineMethods(definitions);
        MockFixture mockFixture = TestRun.mockFixture();
        for (ClassDefinition def : definitions) {
            mockFixture.addRedefinedClass(def.getDefinitionClass(), def.getDefinitionClassFile());
        }
    }

    public void redefineMethods(String mockClassInternalName, byte[] modifiedClassfile, boolean register) {
        this.redefineMethods(modifiedClassfile);
        if (register) {
            this.addToMapOfRedefinedClasses(mockClassInternalName, modifiedClassfile);
        }
    }

    private void addToMapOfRedefinedClasses(String classInternalName, byte[] modifiedClassfile) {
        TestRun.mockFixture().addRedefinedClass(classInternalName, this.realClass, modifiedClassfile);
    }

    private void redefineMethods(byte[] modifiedClassfile) {
        RedefinitionEngine.redefineMethods(new ClassDefinition(this.realClass, modifiedClassfile));
    }

    public static void redefineMethods(ClassDefinition ... classDefs) {
        try {
            Startup.instrumentation().redefineClasses(classDefs);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (UnmodifiableClassException e) {
            throw new RuntimeException(e);
        }
    }

    public void redefineMethods(Map<Class<?>, byte[]> modifiedClassfiles) {
        ClassDefinition[] classDefs = new ClassDefinition[modifiedClassfiles.size()];
        int i = 0;
        for (Map.Entry<Class<?>, byte[]> classAndBytecode : modifiedClassfiles.entrySet()) {
            this.realClass = classAndBytecode.getKey();
            byte[] modifiedClassfile = classAndBytecode.getValue();
            classDefs[i++] = new ClassDefinition(this.realClass, modifiedClassfile);
            this.addToMapOfRedefinedClasses(null, modifiedClassfile);
        }
        RedefinitionEngine.redefineMethods(classDefs);
    }

    public void restoreOriginalDefinition(Class<?> aClass) {
        this.realClass = aClass;
        byte[] realClassFile = new ClassFile(aClass, false).getBytecode();
        this.redefineMethods(realClassFile);
    }

    public void restoreToDefinition(String className, byte[] definitionToRestore) {
        this.realClass = Utilities.loadClass(className);
        this.redefineMethods(definitionToRestore);
    }
}

