/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.annotations;

import java.util.ArrayList;
import java.util.List;
import mockit.internal.annotations.AnnotatedMockStates;
import mockit.internal.annotations.MockClassState;
import mockit.internal.annotations.MockState;
import mockit.internal.state.TestRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotatedMockMethods {
    private String mockClassInternalName;
    private boolean isInnerMockClass;
    private boolean withItField;
    private final List<MockMethod> methods = new ArrayList<MockMethod>();
    final Class<?> realClass;
    private MockClassState mockStates;

    public AnnotatedMockMethods(Class<?> realClass) {
        this.realClass = realClass;
    }

    String addMethod(boolean fromSuperClass, String name, String desc, boolean isStatic) {
        if (fromSuperClass && this.isMethodAlreadyAdded(name, desc)) {
            return null;
        }
        String nameAndDesc = name + desc;
        this.methods.add(new MockMethod(nameAndDesc, isStatic));
        return nameAndDesc;
    }

    private boolean isMethodAlreadyAdded(String name, String desc) {
        int p = desc.lastIndexOf(41);
        String params = desc.substring(0, p + 1);
        for (MockMethod mockMethod : this.methods) {
            if (!mockMethod.name.equals(name) || !mockMethod.desc.startsWith(params)) continue;
            return true;
        }
        return false;
    }

    void addMockState(MockState mockState) {
        AnnotatedMockStates annotatedMockStates = TestRun.getMockClasses().getMockStates();
        if (this.mockStates == null) {
            this.mockStates = annotatedMockStates.addClassState(this.mockClassInternalName);
        }
        this.mockStates.addMockState(mockState);
        if (mockState.isWithExpectations()) {
            annotatedMockStates.registerMockStatesWithExpectations(mockState);
        }
    }

    MockMethod containsMethod(String name, String desc) {
        MockMethod mockFound = this.hasMethod(name, desc);
        if (mockFound != null && this.mockStates != null) {
            mockFound.indexForMockExpectations = this.mockStates.findMockState(mockFound.name + mockFound.desc);
        }
        return mockFound;
    }

    private MockMethod hasMethod(String name, String desc) {
        for (int i = 0; i < this.methods.size(); ++i) {
            MockMethod mockMethod = this.methods.get(i);
            if (!mockMethod.isMatch(name, desc)) continue;
            this.methods.remove(i);
            return mockMethod;
        }
        return null;
    }

    public String getMockClassInternalName() {
        return this.mockClassInternalName;
    }

    void setMockClassInternalName(String mockClassInternalName) {
        this.mockClassInternalName = mockClassInternalName;
    }

    boolean isInnerMockClass() {
        return this.isInnerMockClass;
    }

    void setInnerMockClass(boolean innerMockClass) {
        this.isInnerMockClass = innerMockClass;
    }

    boolean isWithItField() {
        return this.withItField;
    }

    void setWithItField(boolean withItField) {
        this.withItField = withItField;
    }

    public int getMethodCount() {
        return this.methods.size();
    }

    public List<String> getMethods() {
        ArrayList<String> signatures = new ArrayList<String>(this.methods.size());
        for (MockMethod mockMethod : this.methods) {
            signatures.add(mockMethod.name + mockMethod.desc);
        }
        return signatures;
    }

    final class MockMethod {
        final String name;
        final String desc;
        final boolean isStatic;
        final boolean hasInvocationParameter;
        private int indexForMockExpectations;

        private MockMethod(String nameAndDesc, boolean isStatic) {
            int p = nameAndDesc.indexOf(40);
            this.name = nameAndDesc.substring(0, p);
            this.desc = nameAndDesc.substring(p);
            this.isStatic = isStatic;
            this.hasInvocationParameter = this.desc.startsWith("(Lmockit/Invocation;");
            this.indexForMockExpectations = -1;
        }

        private boolean isMatch(String name, String desc) {
            return this.name.equals(name) && (this.hasInvocationParameter ? this.desc.substring(20).equals(desc.substring(1)) : this.desc.equals(desc));
        }

        int getIndexForMockExpectations() {
            return this.indexForMockExpectations;
        }

        boolean isReentrant() {
            return this.indexForMockExpectations >= 0 && AnnotatedMockMethods.this.mockStates.getMockState(this.indexForMockExpectations).isReentrant();
        }
    }
}

