/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.annotations;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import mockit.Invocation;
import mockit.internal.annotations.MockClassState;
import mockit.internal.annotations.MockInvocation;
import mockit.internal.annotations.MockState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotatedMockStates {
    private final Map<String, MockClassState> classStates = new HashMap<String, MockClassState>(8);
    private final Set<MockState> mockStatesWithExpectations = new LinkedHashSet<MockState>(10);

    MockClassState addClassState(String mockClassInternalName) {
        MockClassState mockStates = this.classStates.get(mockClassInternalName);
        if (mockStates == null) {
            mockStates = new MockClassState();
            this.classStates.put(mockClassInternalName, mockStates);
        }
        return mockStates;
    }

    public void removeClassState(Class<?> redefinedClass, String internalNameForOneOrMoreMockClasses) {
        this.removeMockStates(redefinedClass);
        if (internalNameForOneOrMoreMockClasses != null) {
            if (internalNameForOneOrMoreMockClasses.indexOf(32) < 0) {
                this.removeMockStates(internalNameForOneOrMoreMockClasses);
            } else {
                String[] mockClassesInternalNames;
                for (String mockClassInternalName : mockClassesInternalNames = internalNameForOneOrMoreMockClasses.split(" ")) {
                    this.removeMockStates(mockClassInternalName);
                }
            }
        }
    }

    private void removeMockStates(Class<?> redefinedClass) {
        Iterator<Map.Entry<String, MockClassState>> itr = this.classStates.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, MockClassState> mockClassAndItsState = itr.next();
            MockClassState mockClassState = mockClassAndItsState.getValue();
            MockState mockState = mockClassState.mockStates.get(0);
            if (mockState.getRealClass() != redefinedClass) continue;
            this.mockStatesWithExpectations.removeAll(mockClassState.mockStates);
            mockClassState.mockStates.clear();
            itr.remove();
        }
    }

    private void removeMockStates(String mockClassInternalName) {
        MockClassState mockStates = this.classStates.remove(mockClassInternalName);
        if (mockStates != null) {
            this.mockStatesWithExpectations.removeAll(mockStates.mockStates);
        }
    }

    void registerMockStatesWithExpectations(MockState mockState) {
        this.mockStatesWithExpectations.add(mockState);
    }

    public boolean updateMockState(String mockClassName, int mockStateIndex) {
        MockState mockState = this.getMockState(mockClassName, mockStateIndex);
        if (mockState.isOnReentrantCall()) {
            return false;
        }
        mockState.update();
        return true;
    }

    MockState getMockState(String mockClassInternalName, int mockStateIndex) {
        return this.classStates.get(mockClassInternalName).getMockState(mockStateIndex);
    }

    public boolean hasStates(String mockClassInternalName) {
        return this.classStates.containsKey(mockClassInternalName);
    }

    public void exitReentrantMock(String mockClassInternalName, int mockStateIndex) {
        MockState mockState = this.getMockState(mockClassInternalName, mockStateIndex);
        mockState.exitReentrantCall();
    }

    public Invocation createMockInvocation(String mockClassInternalName, int mockStateIndex, Object invokedInstance) {
        MockState mockState = this.getMockState(mockClassInternalName, mockStateIndex);
        return new MockInvocation(invokedInstance, mockState);
    }

    public void verifyExpectations() {
        for (MockState mockState : this.mockStatesWithExpectations) {
            mockState.verifyExpectations();
        }
    }

    public void resetExpectations() {
        for (MockState mockState : this.mockStatesWithExpectations) {
            mockState.reset();
        }
    }
}

