/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.annotations;

import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import mockit.external.asm.ClassReader;
import mockit.external.asm.Label;
import mockit.external.asm.MethodAdapter;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.Type;
import mockit.internal.BaseClassModifier;
import mockit.internal.annotations.AnnotatedMockMethods;
import mockit.internal.filtering.MockingConfiguration;
import mockit.internal.startup.Startup;
import mockit.internal.state.TestRun;
import mockit.internal.util.SuperConstructorCollector;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationsModifier
extends BaseClassModifier {
    private static final int IGNORED_ACCESS = 1280;
    private static final String CLASS_WITH_STATE = "mockit/internal/state/TestRun";
    private final String itFieldDesc;
    private final int mockInstanceIndex;
    private final boolean forStartupMock;
    private final AnnotatedMockMethods annotatedMocks;
    private final MockingConfiguration mockingCfg;
    private final boolean useMockingBridgeForUpdatingMockState;
    private Type mockClassType;
    private String realSuperClassName;
    private AnnotatedMockMethods.MockMethod mockMethod;
    private int varIndex;

    public AnnotationsModifier(ClassReader cr, Class<?> realClass, Object mock, AnnotatedMockMethods mockMethods, MockingConfiguration mockingConfiguration, boolean forStartupMock) {
        super(cr);
        this.itFieldDesc = this.getItFieldDescriptor(realClass);
        this.annotatedMocks = mockMethods;
        this.mockingCfg = mockingConfiguration;
        this.forStartupMock = forStartupMock;
        this.mockInstanceIndex = this.getMockInstanceIndex(mock);
        this.setUseMockingBridge(realClass.getClassLoader());
        this.useMockingBridgeForUpdatingMockState = this.useMockingBridge;
        if (!this.useMockingBridge && mock != null && Utilities.isAnonymousClass(mock.getClass()) && realClass.getPackage() != mock.getClass().getPackage()) {
            this.useMockingBridge = true;
        }
    }

    private String getItFieldDescriptor(Class<?> realClass) {
        if (Proxy.isProxyClass(realClass)) {
            realClass = realClass.getInterfaces()[0];
        }
        return Type.getDescriptor(realClass);
    }

    private int getMockInstanceIndex(Object mock) {
        if (mock != null) {
            return TestRun.getMockClasses().getMocks(this.forStartupMock).addMock(mock);
        }
        if (!this.annotatedMocks.isInnerMockClass()) {
            return -1;
        }
        throw new IllegalArgumentException("An inner mock class cannot be instantiated without its enclosing instance; you must either pass a mock instance, or make the class static");
    }

    public void useOneMockInstancePerMockedInstance(Class<?> mockClass) {
        this.mockClassType = Type.getType(mockClass);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.realSuperClassName = superName;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 0x1000) != 0) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        if (!this.hasMock(name, desc)) {
            return this.shouldCopyOriginalMethodBytecode(access, name, desc, signature, exceptions) ? super.visitMethod(access, name, desc, signature, exceptions) : null;
        }
        this.validateMethodModifiers(access, name);
        this.startModifiedMethodVersion(access, name, desc, signature, exceptions);
        MethodVisitor alternativeWriter = this.getAlternativeMethodWriter(access, desc);
        if (alternativeWriter == null) {
            this.generateCallsForMockExecution(access, desc);
            this.generateMethodReturn(desc);
            this.mw.visitMaxs(1, 0);
            return null;
        }
        return alternativeWriter;
    }

    private boolean hasMock(String name, String desc) {
        String mockName = this.getCorrespondingMockName(name);
        this.mockMethod = this.annotatedMocks.containsMethod(mockName, desc);
        return this.mockMethod != null;
    }

    private String getCorrespondingMockName(String name) {
        if ("<init>".equals(name)) {
            return "$init";
        }
        if ("<clinit>".equals(name)) {
            return "$clinit";
        }
        return name;
    }

    private boolean shouldCopyOriginalMethodBytecode(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 0x500) == 0 && this.mockingCfg != null && this.mockingCfg.matchesFilters(name, desc)) {
            this.startModifiedMethodVersion(access, name, desc, signature, exceptions);
            this.generateEmptyStubImplementation(name, desc);
            return false;
        }
        return true;
    }

    private void generateEmptyStubImplementation(String name, String desc) {
        if ("<init>".equals(name)) {
            this.generateCallToSuper();
        }
        this.generateEmptyImplementation(desc);
    }

    private void validateMethodModifiers(int access, String name) {
        if ((access & 0x400) != 0) {
            throw new IllegalArgumentException("Attempted to mock abstract method \"" + name + '\"');
        }
        if ((access & 0x100) != 0 && !Startup.isJava6OrLater()) {
            throw new IllegalArgumentException("Mocking of native methods not supported under JDK 1.5: \"" + name + '\"');
        }
    }

    private MethodVisitor getAlternativeMethodWriter(int access, String desc) {
        if (!this.mockMethod.isReentrant()) {
            return null;
        }
        if (Modifier.isNative(access)) {
            throw new IllegalArgumentException("Reentrant mocks for native methods are not supported: \"" + this.mockMethod.name + '\"');
        }
        this.generateCallToMock(access, desc);
        return new MethodAdapter(this.mw){

            public void visitLocalVariable(String name, String desc2, String signature, Label start, Label end, int index) {
                if (end.position > 0) {
                    AnnotationsModifier.this.mw.visitLocalVariable(name, desc2, signature, start, end, index);
                }
            }
        };
    }

    private void generateCallsForMockExecution(int access, String desc) {
        if ("$init".equals(this.mockMethod.name)) {
            this.generateCallToSuper();
        }
        this.generateCallToMock(access, desc);
    }

    private void generateCallToSuper() {
        this.mw.visitVarInsn(25, 0);
        String constructorDesc = SuperConstructorCollector.INSTANCE.findConstructor(this.realSuperClassName);
        this.pushDefaultValuesForParameterTypes(constructorDesc);
        this.mw.visitMethodInsn(183, this.realSuperClassName, "<init>", constructorDesc);
    }

    private void generateMockObjectInstantiation() {
        String classInternalName = this.annotatedMocks.getMockClassInternalName();
        this.mw.visitTypeInsn(187, classInternalName);
        this.mw.visitInsn(89);
        this.mw.visitMethodInsn(183, classInternalName, "<init>", "()V");
    }

    private void generateCallToMock(int access, String desc) {
        Label afterCallToMock = this.generateCallToUpdateMockStateIfAny(access);
        Label l1 = null;
        Label l2 = null;
        Label l3 = null;
        if (afterCallToMock != null) {
            Label l0 = new Label();
            l1 = new Label();
            l2 = new Label();
            this.mw.visitTryCatchBlock(l0, l1, l2, null);
            l3 = new Label();
            this.mw.visitTryCatchBlock(l2, l3, l2, null);
            this.mw.visitLabel(l0);
        }
        this.generateCallToMockMethod(access, desc);
        if (afterCallToMock != null) {
            this.mw.visitLabel(l1);
            this.generateCallToExitReentrantMock();
            this.generateMethodReturn(desc);
            this.mw.visitLabel(l2);
            this.mw.visitVarInsn(58, this.varIndex);
            this.mw.visitLabel(l3);
            this.generateCallToExitReentrantMock();
            this.mw.visitVarInsn(25, this.varIndex);
            this.mw.visitInsn(191);
            this.mw.visitLabel(afterCallToMock);
        }
    }

    private Label generateCallToUpdateMockStateIfAny(int access) {
        int mockStateIndex = this.mockMethod.getIndexForMockExpectations();
        Label afterCallToMock = null;
        if (mockStateIndex >= 0) {
            String mockClassDesc = this.annotatedMocks.getMockClassInternalName();
            if (this.useMockingBridgeForUpdatingMockState) {
                this.generateCallToMockingBridge(5, mockClassDesc, access, null, null, null, null, null, mockStateIndex, 0, 0);
                this.mw.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
            } else {
                this.mw.visitLdcInsn(mockClassDesc);
                this.mw.visitIntInsn(17, mockStateIndex);
                this.mw.visitMethodInsn(184, CLASS_WITH_STATE, "updateMockState", "(Ljava/lang/String;I)Z");
            }
            if (this.mockMethod.isReentrant()) {
                afterCallToMock = new Label();
                this.mw.visitJumpInsn(153, afterCallToMock);
            }
        }
        return afterCallToMock;
    }

    private void generateCallToMockMethod(int access, String desc) {
        if (this.mockMethod.isStatic) {
            this.generateStaticMethodCall(access, desc);
        } else {
            this.generateInstanceMethodCall(access, desc);
        }
    }

    private void generateStaticMethodCall(int access, String desc) {
        String mockClassName = this.annotatedMocks.getMockClassInternalName();
        if (this.useMockingBridge) {
            this.generateCallToMockingBridge(3, mockClassName, access, this.mockMethod.name, desc, this.mockMethod.desc, null, null, this.mockMethod.getIndexForMockExpectations(), 0, 0);
        } else {
            this.generateMethodOrConstructorArguments(access);
            this.mw.visitMethodInsn(184, mockClassName, this.mockMethod.name, this.mockMethod.desc);
        }
    }

    private void generateInstanceMethodCall(int access, String desc) {
        if (this.useMockingBridge) {
            this.generateCallToMockingBridge(4, this.annotatedMocks.getMockClassInternalName(), access, this.mockMethod.name, desc, this.mockMethod.desc, null, null, this.mockMethod.getIndexForMockExpectations(), this.mockInstanceIndex, 0);
            return;
        }
        if (this.mockInstanceIndex < 0) {
            this.obtainMockInstanceForInvocation(access);
        } else {
            this.generateGetMockCallWithMockInstanceIndex();
        }
        if ((access & 8) == 0 && this.annotatedMocks.isWithItField()) {
            this.generateItFieldSetting();
        }
        this.generateMockInstanceMethodInvocationWithRealMethodArgs(access);
    }

    private void obtainMockInstanceForInvocation(int access) {
        if (this.mockClassType == null || Modifier.isStatic(access)) {
            this.generateMockObjectInstantiation();
        } else {
            this.generateGetMockCallWithMockClassAndMockedInstance();
        }
    }

    private void generateGetMockCallWithMockClassAndMockedInstance() {
        this.mw.visitLdcInsn(this.mockClassType);
        this.mw.visitVarInsn(25, 0);
        this.mw.visitMethodInsn(184, CLASS_WITH_STATE, "getMock", "(Ljava/lang/Class;Ljava/lang/Object;)Ljava/lang/Object;");
        this.mw.visitTypeInsn(192, this.annotatedMocks.getMockClassInternalName());
    }

    private void generateGetMockCallWithMockInstanceIndex() {
        this.mw.visitIntInsn(17, this.mockInstanceIndex);
        String methodName = this.forStartupMock ? "getStartupMock" : "getMock";
        this.mw.visitMethodInsn(184, CLASS_WITH_STATE, methodName, "(I)Ljava/lang/Object;");
        this.mw.visitTypeInsn(192, this.annotatedMocks.getMockClassInternalName());
    }

    private void generateItFieldSetting() {
        Type[] argTypes = Type.getArgumentTypes(this.mockMethod.desc);
        int var = 1;
        for (Type argType : argTypes) {
            var += argType.getSize();
        }
        this.mw.visitVarInsn(58, var);
        this.mw.visitVarInsn(25, var);
        this.mw.visitVarInsn(25, 0);
        this.mw.visitFieldInsn(181, this.annotatedMocks.getMockClassInternalName(), "it", this.itFieldDesc);
        this.mw.visitVarInsn(25, var);
    }

    private void generateMockInstanceMethodInvocationWithRealMethodArgs(int access) {
        this.generateMethodOrConstructorArguments(access);
        this.mw.visitMethodInsn(182, this.annotatedMocks.getMockClassInternalName(), this.mockMethod.name, this.mockMethod.desc);
    }

    private void generateMethodOrConstructorArguments(int access) {
        boolean hasInvokedInstance = (access & 8) == 0;
        int initialVar = hasInvokedInstance ? 1 : 0;
        Type[] argTypes = Type.getArgumentTypes(this.mockMethod.desc);
        int i = 0;
        if (this.mockMethod.hasInvocationParameter) {
            this.mw.visitLdcInsn(this.annotatedMocks.getMockClassInternalName());
            this.mw.visitIntInsn(17, this.mockMethod.getIndexForMockExpectations());
            this.generateCodeToPassThisOrNullIfStaticMethod(!hasInvokedInstance);
            this.mw.visitMethodInsn(184, CLASS_WITH_STATE, "createMockInvocation", "(Ljava/lang/String;ILjava/lang/Object;)Lmockit/Invocation;");
            i = 1;
        }
        this.varIndex = initialVar;
        while (i < argTypes.length) {
            Type argType = argTypes[i];
            int opcode = argType.getOpcode(21);
            this.mw.visitVarInsn(opcode, this.varIndex);
            this.varIndex += argType.getSize();
            ++i;
        }
    }

    private void generateMethodReturn(String desc) {
        if (this.useMockingBridge) {
            this.generateReturnWithObjectAtTopOfTheStack(desc);
        } else {
            Type returnType = Type.getReturnType(desc);
            this.mw.visitInsn(returnType.getOpcode(172));
        }
    }

    private void generateCallToExitReentrantMock() {
        String mockClassDesc = this.annotatedMocks.getMockClassInternalName();
        int mockStateIndex = this.mockMethod.getIndexForMockExpectations();
        if (this.useMockingBridgeForUpdatingMockState) {
            this.generateCallToMockingBridge(6, mockClassDesc, 8, null, null, null, null, null, mockStateIndex, 0, 0);
            this.mw.visitInsn(87);
        } else {
            this.mw.visitLdcInsn(mockClassDesc);
            this.mw.visitIntInsn(17, mockStateIndex);
            this.mw.visitMethodInsn(184, CLASS_WITH_STATE, "exitReentrantMock", "(Ljava/lang/String;I)V");
        }
    }
}

