/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.capturing;

import java.util.ArrayList;
import java.util.List;
import mockit.Capturing;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassWriter;
import mockit.internal.ClassFile;
import mockit.internal.RedefinitionEngine;
import mockit.internal.capturing.CaptureTransformer;
import mockit.internal.capturing.CapturedType;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.startup.Startup;
import mockit.internal.state.TestRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CaptureOfImplementations {
    private final List<CaptureTransformer> captureTransformers = new ArrayList<CaptureTransformer>();

    protected CaptureOfImplementations() {
    }

    protected abstract ClassWriter createModifier(ClassLoader var1, ClassReader var2, String var3);

    public final void makeSureAllSubtypesAreModified(Capturing capturing) {
        CapturedType captureMetadata = new CapturedType(null, capturing);
        this.makeSureAllSubtypesAreModified(captureMetadata, null, true);
    }

    public final void makeSureAllSubtypesAreModified(MockedType typeMetadata) {
        Class<?> baseType = typeMetadata.getClassType();
        String baseTypeDesc = baseType == null ? null : baseType.getName().replace('.', '/');
        CapturedType captureMetadata = new CapturedType(baseType, typeMetadata.capturing);
        this.makeSureAllSubtypesAreModified(captureMetadata, baseTypeDesc, typeMetadata.fieldFromTestClass);
    }

    private void makeSureAllSubtypesAreModified(CapturedType captureMetadata, String baseTypeDesc, boolean forTestClass) {
        Class[] classesLoaded;
        for (Class aClass : classesLoaded = Startup.instrumentation().getAllLoadedClasses()) {
            if (!captureMetadata.isToBeCaptured(aClass)) continue;
            this.redefineClass(aClass, baseTypeDesc);
        }
        this.createCaptureTransformer(captureMetadata, forTestClass);
    }

    private void redefineClass(Class<?> realClass, String baseTypeDesc) {
        if (!TestRun.mockFixture().containsRedefinedClass(realClass)) {
            ClassReader classReader = new ClassFile(realClass, true).getReader();
            ClassWriter modifier = this.createModifier(realClass.getClassLoader(), classReader, baseTypeDesc);
            classReader.accept(modifier, false);
            byte[] modifiedClass = modifier.toByteArray();
            new RedefinitionEngine(realClass).redefineMethods(null, modifiedClass, true);
        }
    }

    private void createCaptureTransformer(CapturedType captureMetadata, boolean forTestClass) {
        CaptureTransformer transformer = new CaptureTransformer(captureMetadata, this, forTestClass);
        Startup.instrumentation().addTransformer(transformer);
        this.captureTransformers.add(transformer);
    }

    public void cleanUp() {
        for (CaptureTransformer transformer : this.captureTransformers) {
            transformer.deactivate();
            Startup.instrumentation().removeTransformer(transformer);
        }
        this.captureTransformers.clear();
    }
}

