/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.TestOnlyPhase;
import mockit.internal.expectations.VerifiedExpectation;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationArguments;
import mockit.internal.expectations.invocation.InvocationConstraints;
import mockit.internal.expectations.invocation.InvocationHandler;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseVerificationPhase
extends TestOnlyPhase {
    final List<Expectation> expectationsInReplayOrder;
    final List<Object[]> invocationArgumentsInReplayOrder;
    private boolean allInvocationsDuringReplayMustBeVerified;
    private Object[] mockedTypesAndInstancesToFullyVerify;
    protected AssertionError pendingError;

    protected BaseVerificationPhase(RecordAndReplayExecution recordAndReplay, List<Expectation> expectationsInReplayOrder, List<Object[]> invocationArgumentsInReplayOrder) {
        super(recordAndReplay);
        this.expectationsInReplayOrder = expectationsInReplayOrder;
        this.invocationArgumentsInReplayOrder = invocationArgumentsInReplayOrder;
    }

    public final void setAllInvocationsMustBeVerified() {
        this.allInvocationsDuringReplayMustBeVerified = true;
    }

    public final void setMockedTypesToFullyVerify(Object[] mockedTypesAndInstancesToFullyVerify) {
        this.mockedTypesAndInstancesToFullyVerify = mockedTypesAndInstancesToFullyVerify;
    }

    @Override
    final Object handleInvocation(Object mock, int mockAccess, String mockClassDesc, String mockNameAndDesc, String genericSignature, String exceptions, boolean withRealImpl, Object[] args) {
        if (this.pendingError != null) {
            this.recordAndReplay.setErrorThrown(this.pendingError);
            this.pendingError = null;
            return null;
        }
        this.matchInstance = this.nextInstanceToMatch != null && mock == this.nextInstanceToMatch;
        this.currentExpectation = null;
        this.findNonStrictExpectation(mock, mockClassDesc, mockNameAndDesc, args);
        this.argMatchers = null;
        if (this.matchInstance) {
            this.nextInstanceToMatch = null;
        }
        if (this.recordAndReplay.getErrorThrown() != null) {
            return null;
        }
        if (this.currentExpectation == null) {
            ExpectedInvocation currentInvocation = new ExpectedInvocation(mock, mockAccess, mockClassDesc, mockNameAndDesc, false, args);
            this.currentExpectation = new Expectation(null, currentInvocation, true);
            ExpectedInvocation missingInvocation = new ExpectedInvocation(mock, mockClassDesc, mockNameAndDesc, args);
            this.pendingError = missingInvocation.errorForMissingInvocation();
        }
        return this.currentExpectation.invocation.getDefaultValueForReturnType(this);
    }

    abstract void findNonStrictExpectation(Object var1, String var2, String var3, Object[] var4);

    final boolean matches(Object mock, String mockClassDesc, String mockNameAndDesc, Object[] args, Expectation expectation) {
        ExpectedInvocation invocation = expectation.invocation;
        Map<Object, Object> instanceMap = this.getInstanceMap();
        if (invocation.isMatch(mock, mockClassDesc, mockNameAndDesc, instanceMap) && (!this.matchInstance || invocation.isEquivalentInstance(mock, instanceMap))) {
            Object[] argsToVerify = this.argMatchers == null ? args : invocation.arguments.prepareForVerification(args, this.argMatchers);
            boolean argumentsMatch = invocation.arguments.isMatch(argsToVerify, instanceMap);
            if (this.argMatchers != null) {
                invocation.arguments.setValuesWithNoMatchers(argsToVerify);
            }
            if (argumentsMatch) {
                int replayIndex = this.expectationsInReplayOrder.indexOf(expectation);
                this.addVerifiedExpectation(new VerifiedExpectation(expectation, args, this.argMatchers, replayIndex));
                return true;
            }
        }
        return false;
    }

    void addVerifiedExpectation(VerifiedExpectation verifiedExpectation) {
        this.recordAndReplay.executionState.verifiedExpectations.add(verifiedExpectation);
    }

    @Override
    public final void setMaxInvocationCount(int maxInvocations) {
        if (maxInvocations == 0 || this.pendingError == null) {
            super.setMaxInvocationCount(maxInvocations);
        }
    }

    @Override
    public final void setCustomErrorMessage(CharSequence customMessage) {
        Expectation expectation = this.getCurrentExpectation();
        if (this.pendingError == null) {
            expectation.setCustomErrorMessage(customMessage);
        } else if (customMessage != null) {
            StackTraceElement[] previousStackTrace = ((Throwable)((Object)this.pendingError)).getStackTrace();
            this.pendingError = new AssertionError((Object)(customMessage + "\n" + ((Throwable)((Object)this.pendingError)).getMessage()));
            ((Throwable)((Object)this.pendingError)).setStackTrace(previousStackTrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean evaluateInvocationHandlerIfExpectationMatchesCurrent(Expectation expectation, Object[] replayArgs, InvocationHandler handler, int invocationIndex) {
        ExpectedInvocation invocation = expectation.invocation;
        Object mock = invocation.instance;
        String mockClassDesc = invocation.getClassDesc();
        String mockNameAndDesc = invocation.getMethodNameAndDescription();
        Object[] args = invocation.getArgumentValues();
        InvocationConstraints constraints = expectation.constraints;
        if (this.matches(mock, mockClassDesc, mockNameAndDesc, args, this.currentExpectation)) {
            int originalCount = constraints.invocationCount;
            constraints.invocationCount = invocationIndex + 1;
            try {
                handler.invokeMethodOnTargetObject(expectation.invocation.instance, expectation.constraints, replayArgs);
            }
            finally {
                constraints.invocationCount = originalCount;
            }
            return true;
        }
        return false;
    }

    protected AssertionError endVerification() {
        if (this.pendingError != null) {
            return this.pendingError;
        }
        if (this.allInvocationsDuringReplayMustBeVerified) {
            return this.validateThatAllInvocationsWereVerified();
        }
        return null;
    }

    final AssertionError validateThatAllInvocationsWereVerified() {
        ArrayList<Expectation> notVerified = new ArrayList<Expectation>();
        for (int i = 0; i < this.expectationsInReplayOrder.size(); ++i) {
            Object[] replayArgs;
            Expectation replayExpectation = this.expectationsInReplayOrder.get(i);
            if (replayExpectation == null || replayExpectation.constraints.minInvocations > 0 || this.wasVerified(replayExpectation, replayArgs = this.invocationArgumentsInReplayOrder.get(i))) continue;
            notVerified.add(replayExpectation);
        }
        if (!notVerified.isEmpty()) {
            if (this.mockedTypesAndInstancesToFullyVerify == null) {
                Expectation firstUnexpected = (Expectation)notVerified.get(0);
                return firstUnexpected.invocation.errorForUnexpectedInvocation();
            }
            return this.validateThatUnverifiedInvocationsAreAllowed(notVerified);
        }
        return null;
    }

    private boolean wasVerified(Expectation replayExpectation, Object[] replayArgs) {
        InvocationArguments invokedArgs = replayExpectation.invocation.arguments;
        List<VerifiedExpectation> expectationsVerified = this.recordAndReplay.executionState.verifiedExpectations;
        for (int j = 0; j < expectationsVerified.size(); ++j) {
            VerifiedExpectation verified = expectationsVerified.get(j);
            if (verified.expectation != replayExpectation) continue;
            Object[] storedArgs = invokedArgs.prepareForVerification(verified.arguments, verified.argMatchers);
            boolean argumentsMatch = invokedArgs.isMatch(replayArgs, this.getInstanceMap());
            invokedArgs.setValuesWithNoMatchers(storedArgs);
            if (!argumentsMatch) continue;
            if (this.shouldDiscardInformationAboutVerifiedInvocationOnceUsed()) {
                expectationsVerified.remove(j);
            }
            return true;
        }
        invokedArgs.setValuesWithNoMatchers(replayArgs);
        return false;
    }

    boolean shouldDiscardInformationAboutVerifiedInvocationOnceUsed() {
        return false;
    }

    private AssertionError validateThatUnverifiedInvocationsAreAllowed(List<Expectation> unverified) {
        for (Expectation expectation : unverified) {
            ExpectedInvocation invocation = expectation.invocation;
            if (!this.isInvocationToBeVerified(invocation)) continue;
            return invocation.errorForUnexpectedInvocation();
        }
        return null;
    }

    private boolean isInvocationToBeVerified(ExpectedInvocation unverifiedInvocation) {
        String invokedClassName = unverifiedInvocation.getClassName();
        Object invokedInstance = unverifiedInvocation.instance;
        for (Object mockedTypeOrInstance : this.mockedTypesAndInstancesToFullyVerify) {
            Class invokedClass;
            Class mockedType;
            if (!(mockedTypeOrInstance instanceof Class ? invokedClassName.equals((mockedType = (Class)mockedTypeOrInstance).getName()) : (invokedInstance == null ? (invokedClass = Utilities.loadClass(invokedClassName)).isInstance(mockedTypeOrInstance) : (unverifiedInvocation.matchInstance ? mockedTypeOrInstance == invokedInstance : invokedInstance.getClass().isInstance(mockedTypeOrInstance))))) continue;
            return true;
        }
        return false;
    }
}

