/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.ArrayList;
import java.util.List;
import mockit.internal.expectations.BaseVerificationPhase;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.UnorderedVerificationPhase;
import mockit.internal.expectations.VerifiedExpectation;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrderedVerificationPhase
extends BaseVerificationPhase {
    private final int expectationCount;
    private ExpectedInvocation unverifiedInvocationLeftBehind;
    private ExpectedInvocation unverifiedInvocationPrecedingVerifiedOnesLeftBehind;
    private boolean unverifiedExpectationsFixed;
    private int replayIndex;
    private int indexIncrement;

    OrderedVerificationPhase(RecordAndReplayExecution recordAndReplay, List<Expectation> expectationsInReplayOrder, List<Object[]> invocationArgumentsInReplayOrder) {
        super(recordAndReplay, new ArrayList<Expectation>(expectationsInReplayOrder), invocationArgumentsInReplayOrder);
        this.discardExpectationsAndArgumentsAlreadyVerified();
        this.expectationCount = expectationsInReplayOrder.size();
        this.indexIncrement = 1;
    }

    private void discardExpectationsAndArgumentsAlreadyVerified() {
        for (VerifiedExpectation verified : this.recordAndReplay.executionState.verifiedExpectations) {
            int i = this.expectationsInReplayOrder.indexOf(verified.expectation);
            if (i < 0) continue;
            this.expectationsInReplayOrder.set(i, null);
        }
    }

    @Override
    protected void findNonStrictExpectation(Object mock, String mockClassDesc, String mockNameAndDesc, Object[] args) {
        for (int i = this.replayIndex; i >= 0 && i < this.expectationCount; i += this.indexIncrement) {
            Expectation expectation = (Expectation)this.expectationsInReplayOrder.get(i);
            if (expectation == null) continue;
            if (this.matches(mock, mockClassDesc, mockNameAndDesc, args, expectation)) {
                this.currentExpectation = expectation;
                i += 1 - this.indexIncrement;
                this.indexIncrement = 1;
                if (this.argMatchers != null) {
                    expectation.invocation.arguments.setMatchers(this.argMatchers);
                }
                this.replayIndex = i;
                break;
            }
            if (this.unverifiedExpectationsFixed) continue;
            this.unverifiedInvocationLeftBehind = expectation.invocation;
        }
    }

    public void fixPositionOfUnverifiedExpectations() {
        if (this.unverifiedInvocationLeftBehind != null) {
            throw this.currentExpectation == null ? this.unverifiedInvocationLeftBehind.errorForUnexpectedInvocation() : this.unverifiedInvocationLeftBehind.errorForUnexpectedInvocationBeforeAnother(this.currentExpectation.invocation);
        }
        this.replayIndex = this.indexOfLastUnverifiedExpectation();
        this.indexIncrement = -1;
        this.unverifiedExpectationsFixed = true;
    }

    private int indexOfLastUnverifiedExpectation() {
        for (int i = this.expectationCount - 1; i >= 0; --i) {
            if (this.expectationsInReplayOrder.get(i) == null) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void handleInvocationCountConstraint(int minInvocations, int maxInvocations) {
        int multiplier;
        if (this.pendingError != null && minInvocations > 0) {
            return;
        }
        ExpectedInvocation invocation = this.currentExpectation.invocation;
        this.argMatchers = invocation.arguments.getMatchers();
        int invocationCount = 1;
        while (this.replayIndex < this.expectationCount) {
            Expectation expectation = (Expectation)this.expectationsInReplayOrder.get(this.replayIndex);
            if (this.matchesCurrentExpectation(expectation)) {
                if (++invocationCount > maxInvocations) {
                    if (maxInvocations < 0 || this.numberOfIterations > 1) break;
                    this.pendingError = expectation.invocation.errorForUnexpectedInvocation();
                    return;
                }
            } else if (invocationCount >= minInvocations) break;
            ++this.replayIndex;
        }
        this.argMatchers = null;
        int n = minInvocations - invocationCount;
        if (n > 0) {
            this.pendingError = invocation.errorForMissingInvocations(n);
            return;
        }
        if (maxInvocations >= 0 && (n = this.currentExpectation.constraints.invocationCount - maxInvocations * (multiplier = this.numberOfIterations <= 1 ? 1 : this.numberOfIterations)) > 0) {
            this.pendingError = invocation.errorForUnexpectedInvocations(n);
            return;
        }
        this.pendingError = null;
    }

    private boolean matchesCurrentExpectation(Expectation expectation) {
        if (expectation == this.currentExpectation) {
            return true;
        }
        ExpectedInvocation invocation = this.currentExpectation.invocation;
        Object mock = invocation.instance;
        String mockClassDesc = invocation.getClassDesc();
        String mockNameAndDesc = invocation.getMethodNameAndDescription();
        Object[] args = invocation.arguments.getValues();
        return this.matches(mock, mockClassDesc, mockNameAndDesc, args, expectation);
    }

    @Override
    public void applyHandlerForEachInvocation(Object invocationHandler) {
        Object[] args;
        Expectation expectation;
        if (this.pendingError != null) {
            return;
        }
        this.getCurrentExpectation();
        InvocationHandler handler = new InvocationHandler(invocationHandler);
        for (int i = this.expectationsInReplayOrder.indexOf(this.currentExpectation); i < this.expectationCount && ((expectation = (Expectation)this.expectationsInReplayOrder.get(i)) == null || this.evaluateInvocationHandlerIfExpectationMatchesCurrent(expectation, args = (Object[])this.invocationArgumentsInReplayOrder.get(i), handler, i)); ++i) {
        }
    }

    @Override
    protected AssertionError endVerification() {
        if (this.pendingError != null) {
            return this.pendingError;
        }
        if (this.unverifiedExpectationsFixed && this.indexIncrement > 0 && this.currentExpectation != null && this.replayIndex <= this.indexOfLastUnverifiedExpectation()) {
            return new AssertionError((Object)("Unexpected invocations after" + this.currentExpectation.invocation));
        }
        if (this.unverifiedInvocationPrecedingVerifiedOnesLeftBehind != null) {
            return this.unverifiedInvocationPrecedingVerifiedOnesLeftBehind.errorForUnexpectedInvocation();
        }
        AssertionError error = this.verifyRemainingIterations();
        if (error != null) {
            return error;
        }
        return super.endVerification();
    }

    private AssertionError verifyRemainingIterations() {
        int expectationsVerifiedInFirstIteration = this.recordAndReplay.executionState.verifiedExpectations.size();
        for (int i = 1; i < this.numberOfIterations; ++i) {
            AssertionError error = this.verifyNextIterationOfWholeBlockOfInvocations(expectationsVerifiedInFirstIteration);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    private AssertionError verifyNextIterationOfWholeBlockOfInvocations(int expectationsVerifiedInFirstIteration) {
        List<VerifiedExpectation> expectationsVerified = this.recordAndReplay.executionState.verifiedExpectations;
        for (int i = 0; i < expectationsVerifiedInFirstIteration; ++i) {
            ExpectedInvocation invocation = expectationsVerified.get((int)i).expectation.invocation;
            this.argMatchers = invocation.arguments.getMatchers();
            this.handleInvocation(invocation.instance, 0, invocation.getClassDesc(), invocation.getMethodNameAndDescription(), null, null, false, invocation.arguments.getValues());
            AssertionError testFailure = this.recordAndReplay.getErrorThrown();
            if (testFailure == null) continue;
            return testFailure;
        }
        return null;
    }

    @Override
    boolean shouldDiscardInformationAboutVerifiedInvocationOnceUsed() {
        return true;
    }

    public void checkOrderOfVerifiedInvocations(BaseVerificationPhase verificationPhase) {
        if (verificationPhase instanceof OrderedVerificationPhase) {
            throw new IllegalArgumentException("Invalid use of ordered verification block");
        }
        UnorderedVerificationPhase previousVerification = (UnorderedVerificationPhase)verificationPhase;
        if (previousVerification.verifiedExpectations.isEmpty()) {
            return;
        }
        if (this.indexIncrement > 0) {
            this.checkForwardOrderOfVerifiedInvocations(previousVerification);
        } else {
            this.checkBackwardOrderOfVerifiedInvocations(previousVerification);
        }
    }

    private void checkForwardOrderOfVerifiedInvocations(UnorderedVerificationPhase previousVerification) {
        int maxReplayIndex = this.replayIndex - 1;
        for (VerifiedExpectation verified : previousVerification.verifiedExpectations) {
            if (verified.replayIndex < this.replayIndex) {
                throw verified.expectation.invocation.errorForUnexpectedInvocationBeforeAnother(this.currentExpectation.invocation);
            }
            if (verified.replayIndex <= maxReplayIndex) continue;
            maxReplayIndex = verified.replayIndex;
        }
        for (int i = this.replayIndex; i < maxReplayIndex; ++i) {
            Expectation expectation = (Expectation)this.expectationsInReplayOrder.get(i);
            if (expectation == null) continue;
            this.unverifiedInvocationPrecedingVerifiedOnesLeftBehind = expectation.invocation;
            break;
        }
        this.replayIndex = maxReplayIndex + 1;
        this.currentExpectation = this.replayIndex < this.expectationCount ? (Expectation)this.expectationsInReplayOrder.get(this.replayIndex) : null;
    }

    private void checkBackwardOrderOfVerifiedInvocations(UnorderedVerificationPhase previousVerification) {
        VerifiedExpectation firstVerified = previousVerification.firstExpectationVerified();
        int indexOfLastUnverified = this.indexOfLastUnverifiedExpectation();
        if (firstVerified.replayIndex != indexOfLastUnverified + 1) {
            Expectation lastUnverified = (Expectation)this.expectationsInReplayOrder.get(indexOfLastUnverified);
            throw lastUnverified.invocation.errorForUnexpectedInvocationAfterAnother(firstVerified.expectation.invocation);
        }
    }
}

