/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.VerifiedExpectation;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationArguments;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PhasedExecutionState {
    final List<Expectation> expectations = new ArrayList<Expectation>();
    final List<Expectation> nonStrictExpectations = new ArrayList<Expectation>();
    final List<VerifiedExpectation> verifiedExpectations = new ArrayList<VerifiedExpectation>();
    final Map<Object, Object> instanceMap = new IdentityHashMap<Object, Object>();
    private List<Class<?>> mockedTypesToMatchOnInstances;

    PhasedExecutionState() {
    }

    void discoverMockedTypesToMatchOnInstances(List<Class<?>> targetClasses) {
        int numClasses = targetClasses.size();
        if (numClasses > 1) {
            for (int i = 0; i < numClasses; ++i) {
                Class<?> targetClass = targetClasses.get(i);
                if (targetClasses.lastIndexOf(targetClass) <= i) continue;
                this.addMockedTypeToMatchOnInstance(targetClass);
            }
        }
    }

    private void addMockedTypeToMatchOnInstance(Class<?> mockedType) {
        if (this.mockedTypesToMatchOnInstances == null) {
            this.mockedTypesToMatchOnInstances = new LinkedList();
        }
        this.mockedTypesToMatchOnInstances.add(mockedType);
    }

    void addExpectation(Expectation expectation, boolean nonStrict) {
        ExpectedInvocation invocation = expectation.invocation;
        this.forceMatchingOnMockInstanceIfRequired(invocation);
        this.removeMatchingExpectationsCreatedBefore(invocation);
        if (nonStrict) {
            this.nonStrictExpectations.add(expectation);
        } else {
            this.expectations.add(expectation);
        }
    }

    private void forceMatchingOnMockInstanceIfRequired(ExpectedInvocation invocation) {
        Class<?> mockedClass;
        Object mock;
        if (this.mockedTypesToMatchOnInstances != null && (mock = invocation.instance) != null && this.mockedTypesToMatchOnInstances.contains(mockedClass = Utilities.getMockedClass(mock))) {
            invocation.matchInstance = true;
        }
    }

    private void removeMatchingExpectationsCreatedBefore(ExpectedInvocation invocation) {
        Expectation previousExpectation = this.findPreviousNonStrictExpectation(invocation);
        if (previousExpectation != null) {
            this.nonStrictExpectations.remove(previousExpectation);
            invocation.copyDefaultReturnValue(previousExpectation.invocation);
        }
    }

    private Expectation findPreviousNonStrictExpectation(ExpectedInvocation newInvocation) {
        Object mock = newInvocation.instance;
        String mockClassDesc = newInvocation.getClassDesc();
        String mockNameAndDesc = newInvocation.getMethodNameAndDescription();
        InvocationArguments arguments = newInvocation.arguments;
        Object[] argValues = arguments.getValues();
        boolean newInvocationWithMatchers = arguments.getMatchers() != null;
        int n = this.nonStrictExpectations.size();
        for (int i = 0; i < n; ++i) {
            Expectation previousExpectation = this.nonStrictExpectations.get(i);
            ExpectedInvocation previousInvocation = previousExpectation.invocation;
            if (!this.isInvocationToSameMethodOrConstructor(mock, mockClassDesc, mockNameAndDesc, previousInvocation) || (!newInvocationWithMatchers || !arguments.hasEquivalentMatchers(previousInvocation.arguments)) && (newInvocationWithMatchers || !previousInvocation.arguments.isMatch(argValues, this.instanceMap))) continue;
            return previousExpectation;
        }
        return null;
    }

    private boolean isInvocationToSameMethodOrConstructor(Object mock, String mockClassDesc, String mockNameAndDesc, ExpectedInvocation invocation) {
        return invocation.isMatch(mockClassDesc, mockNameAndDesc) && invocation.isMatch(mock, this.instanceMap);
    }

    Expectation findNonStrictExpectation(Object mock, String mockClassDesc, String mockNameAndDesc, Object[] args) {
        int n = this.nonStrictExpectations.size();
        for (int i = 0; i < n; ++i) {
            Expectation nonStrict = this.nonStrictExpectations.get(i);
            ExpectedInvocation invocation = nonStrict.invocation;
            if (!this.isInvocationToSameMethodOrConstructor(mock, mockClassDesc, mockNameAndDesc, invocation) || !invocation.arguments.isMatch(args, this.instanceMap)) continue;
            return nonStrict;
        }
        return null;
    }

    void makeNonStrict(Expectation expectation) {
        if (this.expectations.remove(expectation)) {
            expectation.constraints.setDefaultLimits(true);
            this.nonStrictExpectations.add(expectation);
        }
    }
}

