/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.TestOnlyPhase;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationHandler;
import mockit.internal.state.ExecutingTest;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

public final class RecordPhase
extends TestOnlyPhase {
    private final boolean nonStrict;

    RecordPhase(RecordAndReplayExecution recordAndReplay, boolean nonStrict) {
        super(recordAndReplay);
        this.nonStrict = nonStrict;
    }

    public void addResult(Object result) {
        this.getCurrentExpectation().addResult(result);
    }

    public void addReturnValueOrValues(Object value) {
        this.getCurrentExpectation().addReturnValueOrValues(value);
    }

    public void addSequenceOfReturnValues(Object firstValue, Object[] remainingValues) {
        this.getCurrentExpectation().addSequenceOfReturnValues(firstValue, remainingValues);
    }

    public void setNotStrict() {
        this.recordAndReplay.executionState.makeNonStrict(this.currentExpectation);
    }

    Object handleInvocation(Object mock, int access, String classDesc, String mockNameAndDesc, String genericSignature, String exceptions, boolean withRealImpl, Object[] args) throws Throwable {
        boolean nonStrictInvocation;
        mock = this.configureMatchingOnMockInstanceIfSpecified(mock);
        ExpectedInvocation invocation = new ExpectedInvocation(mock, access, classDesc, mockNameAndDesc, this.matchInstance, args);
        ExecutingTest executingTest = TestRun.getExecutingTest();
        boolean bl = nonStrictInvocation = this.nonStrict || executingTest.isNonStrictInvocation(mock, classDesc, mockNameAndDesc);
        if (!nonStrictInvocation) {
            String mockClassDesc = this.matchInstance ? null : classDesc;
            executingTest.addStrictMock(mock, mockClassDesc);
        }
        this.currentExpectation = new Expectation(this, invocation, nonStrictInvocation);
        if (this.argMatchers != null) {
            invocation.arguments.setMatchers(this.argMatchers);
            this.argMatchers = null;
        }
        this.recordAndReplay.executionState.addExpectation(this.currentExpectation, nonStrictInvocation);
        return invocation.getDefaultValueForReturnType(this);
    }

    private Object configureMatchingOnMockInstanceIfSpecified(Object mock) {
        Class<?> mockedClass;
        this.matchInstance = false;
        if (mock == null || this.nextInstanceToMatch == null) {
            return mock;
        }
        Object specified = this.nextInstanceToMatch;
        if (mock != specified && !(mockedClass = Utilities.getMockedClass(mock)).isInstance(specified)) {
            return mock;
        }
        this.nextInstanceToMatch = null;
        this.matchInstance = true;
        return specified;
    }

    public void handleInvocationCountConstraint(int minInvocations, int maxInvocations) {
        int lowerLimit = minInvocations;
        int upperLimit = maxInvocations;
        if (this.numberOfIterations > 1 && this.nonStrict) {
            lowerLimit *= this.numberOfIterations;
            upperLimit *= this.numberOfIterations;
        }
        this.getCurrentExpectation().constraints.setLimits(lowerLimit, upperLimit);
    }

    public void setCustomErrorMessage(CharSequence customMessage) {
        this.getCurrentExpectation().setCustomErrorMessage(customMessage);
    }

    public void applyHandlerForEachInvocation(Object invocationHandler) {
        this.getCurrentExpectation().getResults().addResult(new InvocationHandler(invocationHandler));
    }
}

