/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import mockit.external.hamcrest.HamcrestAdapter;
import mockit.external.hamcrest.Matcher;
import mockit.external.hamcrest.StringDescription;
import mockit.external.hamcrest.core.IsAnything;
import mockit.external.hamcrest.core.IsEqual;
import mockit.internal.util.MethodFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InvocationArguments {
    private static final Object[] NULL_VARARGS = new Object[0];
    private static final Matcher<?> ANYTHING = new IsAnything();
    final String classDesc;
    final String methodNameAndDesc;
    final String genericSignature;
    final String[] exceptions;
    private final int methodAccess;
    private Object[] invocationArgs;
    private List<Matcher<?>> matchers;

    InvocationArguments(int access, String classDesc, String methodNameAndDesc, String genericSignature, String exceptions, Object[] args) {
        this.methodAccess = access;
        this.classDesc = classDesc;
        this.methodNameAndDesc = methodNameAndDesc;
        this.genericSignature = genericSignature;
        this.exceptions = exceptions == null ? null : exceptions.split(" ");
        this.invocationArgs = args;
    }

    public String getGenericSignature() {
        return this.genericSignature == null ? this.methodNameAndDesc : this.genericSignature;
    }

    public Object[] getValues() {
        return this.invocationArgs;
    }

    public void setValuesWithNoMatchers(Object[] argsToVerify) {
        this.invocationArgs = argsToVerify;
        this.matchers = null;
    }

    public List<Matcher<?>> getMatchers() {
        return this.matchers;
    }

    public void setMatchers(List<Matcher<?>> matchers) {
        this.matchers = matchers;
    }

    public Object[] prepareForVerification(Object[] argsToVerify, List<Matcher<?>> matchers) {
        Object[] replayArgs = this.invocationArgs;
        this.invocationArgs = argsToVerify;
        this.matchers = matchers;
        return replayArgs;
    }

    public boolean isMatch(Object[] replayArgs, Map<Object, Object> instanceMap) {
        if (this.matchers == null) {
            return this.areEqual(replayArgs, instanceMap);
        }
        int argCount = replayArgs.length;
        Object[] replayVarArgs = replayArgs;
        Object[] invocationVarArgs = this.invocationArgs;
        int varArgsCount = 0;
        if (this.isVarargsMethod()) {
            invocationVarArgs = this.getVarArgs(this.invocationArgs);
            replayVarArgs = this.getVarArgs(replayArgs);
            if (invocationVarArgs != NULL_VARARGS && (varArgsCount = replayVarArgs.length) != invocationVarArgs.length) {
                return false;
            }
            --argCount;
        }
        int n = argCount + varArgsCount;
        for (int i = 0; i < n; ++i) {
            IsEqual<Object> expected;
            Object actual = this.getArgument(replayArgs, replayVarArgs, argCount, i);
            IsEqual<Object> isEqual = expected = i < this.matchers.size() ? this.matchers.get(i) : null;
            if (expected == null) {
                Object arg = this.getArgument(this.invocationArgs, invocationVarArgs, argCount, i);
                IsEqual<Object> isEqual2 = expected = arg == null ? ANYTHING : new IsEqual<Object>(arg);
            }
            if (expected.matches(actual)) continue;
            return false;
        }
        return true;
    }

    private boolean areEqual(Object[] replayArgs, Map<Object, Object> instanceMap) {
        Object[] actualValues;
        int argCount = replayArgs.length;
        if (!this.isVarargsMethod()) {
            return this.areEqual(this.invocationArgs, replayArgs, argCount, instanceMap);
        }
        if (!this.areEqual(this.invocationArgs, replayArgs, argCount - 1, instanceMap)) {
            return false;
        }
        Object[] expectedValues = this.getVarArgs(this.invocationArgs);
        return expectedValues.length == (actualValues = this.getVarArgs(replayArgs)).length && this.areEqual(expectedValues, actualValues, expectedValues.length, instanceMap);
    }

    private boolean isVarargsMethod() {
        return (this.methodAccess & 0x80) != 0;
    }

    private Object[] getVarArgs(Object[] args) {
        Object lastArg = args[args.length - 1];
        if (lastArg == null) {
            return NULL_VARARGS;
        }
        if (lastArg instanceof Object[]) {
            return (Object[])lastArg;
        }
        int varArgsLength = Array.getLength(lastArg);
        Object[] results = new Object[varArgsLength];
        for (int i = 0; i < varArgsLength; ++i) {
            results[i] = Array.get(lastArg, i);
        }
        return results;
    }

    private boolean areEqual(Object[] expectedValues, Object[] actualValues, int count, Map<Object, Object> instanceMap) {
        for (int i = 0; i < count; ++i) {
            if (!this.isNotEqual(expectedValues[i], actualValues[i], instanceMap)) continue;
            return false;
        }
        return true;
    }

    private boolean isNotEqual(Object expected, Object actual, Map<Object, Object> instanceMap) {
        return actual == null && expected != null || actual != null && expected == null || actual != null && actual != expected && actual != instanceMap.get(expected) && !IsEqual.areEqualWhenNonNull(actual, expected);
    }

    private Object getArgument(Object[] regularArgs, Object[] varArgs, int regularArgCount, int i) {
        return i < regularArgCount ? regularArgs[i] : varArgs[i - regularArgCount];
    }

    public AssertionError assertMatch(Object[] replayArgs, Map<Object, Object> instanceMap) {
        if (this.matchers == null) {
            return this.assertEquality(replayArgs, instanceMap);
        }
        int argCount = replayArgs.length;
        Object[] replayVarArgs = replayArgs;
        Object[] invocationVarArgs = this.invocationArgs;
        int varArgsCount = 0;
        if (this.isVarargsMethod()) {
            invocationVarArgs = this.getVarArgs(this.invocationArgs);
            replayVarArgs = this.getVarArgs(replayArgs);
            if (invocationVarArgs != NULL_VARARGS && (varArgsCount = replayVarArgs.length) != invocationVarArgs.length) {
                return this.errorForVarargsArraysOfDifferentLengths(invocationVarArgs, replayVarArgs);
            }
            --argCount;
        }
        int n = argCount + varArgsCount;
        for (int i = 0; i < n; ++i) {
            IsEqual<Object> expected;
            Object actual = this.getArgument(replayArgs, replayVarArgs, argCount, i);
            IsEqual<Object> isEqual = expected = i < this.matchers.size() ? this.matchers.get(i) : null;
            if (expected == null) {
                Object arg = this.getArgument(this.invocationArgs, invocationVarArgs, argCount, i);
                IsEqual<Object> isEqual2 = expected = arg == null ? ANYTHING : new IsEqual<Object>(arg);
            }
            if (expected.matches(actual)) continue;
            return this.argumentMismatchMessage(i, expected, actual);
        }
        return null;
    }

    private AssertionError assertEquality(Object[] replayArgs, Map<Object, Object> instanceMap) {
        Object[] actualValues;
        int argCount = replayArgs.length;
        if (!this.isVarargsMethod()) {
            return this.assertEquals(this.invocationArgs, replayArgs, argCount, instanceMap);
        }
        AssertionError nonVarargsError = this.assertEquals(this.invocationArgs, replayArgs, argCount - 1, instanceMap);
        if (nonVarargsError != null) {
            return nonVarargsError;
        }
        Object[] expectedValues = this.getVarArgs(this.invocationArgs);
        if (expectedValues.length != (actualValues = this.getVarArgs(replayArgs)).length) {
            return this.errorForVarargsArraysOfDifferentLengths(expectedValues, actualValues);
        }
        AssertionError varargsError = this.assertEquals(expectedValues, actualValues, expectedValues.length, instanceMap);
        if (varargsError != null) {
            return new AssertionError((Object)("Varargs " + varargsError));
        }
        return null;
    }

    private AssertionError errorForVarargsArraysOfDifferentLengths(Object[] expectedValues, Object[] actualValues) {
        return new AssertionError((Object)("Expected " + expectedValues.length + " values for varargs parameter, got " + actualValues.length));
    }

    private AssertionError assertEquals(Object[] expectedValues, Object[] actualValues, int count, Map<Object, Object> instanceMap) {
        for (int i = 0; i < count; ++i) {
            Object expected = expectedValues[i];
            Object actual = actualValues[i];
            if (!this.isNotEqual(expected, actual, instanceMap)) continue;
            return this.argumentMismatchMessage(i, expected, actual);
        }
        return null;
    }

    private AssertionError argumentMismatchMessage(int paramIndex, Object expected, Object actual) {
        StringBuilder message = new StringBuilder(50);
        message.append("Parameter ").append(paramIndex);
        message.append(" of ").append(new MethodFormatter(this.classDesc, this.methodNameAndDesc));
        message.append(" expected ");
        this.appendParameterValue(message, expected);
        message.append(", got ");
        this.appendParameterValue(message, actual);
        return new AssertionError((Object)message.toString());
    }

    private void appendParameterValue(StringBuilder message, Object parameterValue) {
        if (parameterValue == null) {
            message.append("null");
        } else if (parameterValue instanceof CharSequence || parameterValue instanceof Appendable) {
            message.append('\"').append(parameterValue).append('\"');
        } else if (parameterValue instanceof Character) {
            message.append('\'').append(parameterValue).append('\'');
        } else if (parameterValue.getClass().isArray()) {
            String desc = Arrays.deepToString(new Object[]{parameterValue});
            message.append(desc.substring(1, desc.length() - 1));
        } else {
            message.append(parameterValue);
        }
    }

    public String toString() {
        StringBuilder desc = new StringBuilder(30);
        desc.append(":\n").append(new MethodFormatter(this.classDesc, this.methodNameAndDesc));
        if (this.invocationArgs.length > 0) {
            desc.append("\nwith arguments: ");
            String sep = "";
            for (Object arg : this.invocationArgs) {
                desc.append(sep);
                this.appendParameterValue(desc, arg);
                sep = ", ";
            }
        }
        return desc.toString();
    }

    public boolean hasEquivalentMatchers(InvocationArguments other) {
        List<Matcher<?>> otherMatchers = other.matchers;
        if (otherMatchers == null || otherMatchers.size() != this.matchers.size()) {
            return false;
        }
        for (int i = 0; i < this.matchers.size(); ++i) {
            Matcher<?> matcher2;
            Matcher<?> matcher1 = this.matchers.get(i);
            if (matcher1 == (matcher2 = otherMatchers.get(i))) continue;
            if (matcher1.getClass() != matcher2.getClass() || matcher1.getClass() == HamcrestAdapter.class) {
                return false;
            }
            if (this.equivalentMatches(matcher1, this.invocationArgs[i], matcher2, other.invocationArgs[i])) continue;
            return false;
        }
        return true;
    }

    private boolean equivalentMatches(Matcher<?> matcher1, Object arg1, Matcher<?> matcher2, Object arg2) {
        boolean matcher1MatchesArg2 = matcher1.matches(arg2);
        boolean matcher2MatchesArg1 = matcher2.matches(arg1);
        if (arg1 != null && arg2 != null && matcher1MatchesArg2 && matcher2MatchesArg1) {
            return true;
        }
        if (arg1 == arg2 && matcher1MatchesArg2 == matcher2MatchesArg1) {
            StringDescription desc1 = new StringDescription();
            matcher1.describeTo(desc1);
            StringDescription desc2 = new StringDescription();
            matcher2.describeTo(desc2);
            return ((Object)desc1).toString().equals(((Object)desc2).toString());
        }
        return false;
    }
}

