/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.util.Iterator;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationConstraints;

abstract class InvocationResult {
    InvocationResult next;

    InvocationResult() {
    }

    abstract Object produceResult(Object var1, ExpectedInvocation var2, InvocationConstraints var3, Object[] var4) throws Throwable;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DeferredResults
    extends InvocationResult {
        private final Iterator<?> values;

        DeferredResults(Iterator<?> values) {
            this.values = values;
        }

        @Override
        Object produceResult(Object invokedObject, ExpectedInvocation invocation, InvocationConstraints constraints, Object[] args) throws Throwable {
            Object nextValue;
            Object v0 = nextValue = this.values.hasNext() ? this.values.next() : null;
            if (nextValue instanceof Throwable) {
                Throwable t = nextValue;
                t.fillInStackTrace();
                throw t;
            }
            return nextValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DeferredReturnValues
    extends InvocationResult {
        private final Iterator<?> values;

        DeferredReturnValues(Iterator<?> values) {
            this.values = values;
        }

        @Override
        Object produceResult(Object invokedObject, ExpectedInvocation invocation, InvocationConstraints constraints, Object[] args) throws Throwable {
            return this.values.hasNext() ? this.values.next() : null;
        }
    }

    static final class ThrowableResult
    extends InvocationResult {
        private final Throwable throwable;

        ThrowableResult(Throwable throwable) {
            this.throwable = throwable;
        }

        Object produceResult(Object invokedObject, ExpectedInvocation invocation, InvocationConstraints constraints, Object[] args) throws Throwable {
            this.throwable.fillInStackTrace();
            throw this.throwable;
        }
    }

    static final class ReturnValueResult
    extends InvocationResult {
        private final Object returnValue;

        ReturnValueResult(Object returnValue) {
            this.returnValue = returnValue;
        }

        Object produceResult(Object invokedObject, ExpectedInvocation invocation, InvocationConstraints constraints, Object[] args) {
            return this.returnValue;
        }
    }
}

