/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.lang.reflect.Array;
import java.util.Iterator;
import mockit.Delegate;
import mockit.internal.expectations.invocation.DelegatedResult;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationConstraints;
import mockit.internal.expectations.invocation.InvocationResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InvocationResults {
    private final ExpectedInvocation invocation;
    private final InvocationConstraints constraints;
    private InvocationResult currentResult;
    private InvocationResult lastResult;
    private int resultCount;

    public InvocationResults(ExpectedInvocation invocation, InvocationConstraints constraints) {
        this.invocation = invocation;
        this.constraints = constraints;
    }

    public void addReturnValue(Object value) {
        InvocationResult result = value instanceof Delegate ? new DelegatedResult((Delegate)value) : new InvocationResult.ReturnValueResult(value);
        this.addResult(result);
    }

    public void addReturnValues(Object array) {
        int n = Array.getLength(array);
        for (int i = 0; i < n; ++i) {
            Object value = Array.get(array, i);
            this.addReturnValue(value);
        }
    }

    public void addReturnValues(Iterable<?> values) {
        for (Object value : values) {
            this.addReturnValue(value);
        }
    }

    public void addReturnValues(Object ... values) {
        for (Object value : values) {
            this.addReturnValue(value);
        }
    }

    public void addResults(Object array) {
        int n = Array.getLength(array);
        for (int i = 0; i < n; ++i) {
            Object value = Array.get(array, i);
            this.addConsecutiveResult(value);
        }
    }

    private void addConsecutiveResult(Object result) {
        if (result instanceof Throwable) {
            this.addThrowable((Throwable)result);
        } else {
            this.addReturnValue(result);
        }
    }

    public void addResults(Iterable<?> values) {
        for (Object value : values) {
            this.addConsecutiveResult(value);
        }
    }

    public void addDeferredReturnValues(Iterator<?> values) {
        InvocationResult.DeferredReturnValues result = new InvocationResult.DeferredReturnValues(values);
        this.addResult(result);
        this.constraints.setUnlimitedMaxInvocations();
    }

    public void addDeferredResults(Iterator<?> values) {
        InvocationResult.DeferredResults result = new InvocationResult.DeferredResults(values);
        this.addResult(result);
        this.constraints.setUnlimitedMaxInvocations();
    }

    public void addThrowable(Throwable t) {
        this.addResult(new InvocationResult.ThrowableResult(t));
    }

    public void addResult(InvocationResult result) {
        ++this.resultCount;
        this.constraints.adjustMaxInvocations(this.resultCount);
        if (this.currentResult == null) {
            this.currentResult = result;
            this.lastResult = result;
        } else {
            this.lastResult.next = result;
            this.lastResult = result;
        }
    }

    public Object produceResult(Object invokedObject, Object[] invocationArgs) throws Throwable {
        InvocationResult resultToBeProduced = this.currentResult;
        InvocationResult nextResult = resultToBeProduced.next;
        if (nextResult != null) {
            this.currentResult = nextResult;
        }
        Object result = resultToBeProduced.produceResult(invokedObject, this.invocation, this.constraints, invocationArgs);
        return result;
    }
}

