/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import mockit.Expectations;
import mockit.Input;
import mockit.NonStrictExpectations;
import mockit.internal.expectations.mocking.CaptureOfNewInstancesForFields;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.expectations.mocking.TypeRedefinitions;
import mockit.internal.state.DefaultResults;
import mockit.internal.state.TestRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldTypeRedefinitions
extends TypeRedefinitions {
    private static final int FIELD_ACCESS_MASK = 4104;
    protected Field field;
    protected boolean finalField;

    protected FieldTypeRedefinitions(Object objectWithMockFields) {
        super(objectWithMockFields);
    }

    protected final void redefineFieldTypes(Class<?> classWithMockFields, boolean isTestClass) {
        Class<?> superClass = classWithMockFields.getSuperclass();
        if (superClass != null && superClass != Object.class && superClass != Expectations.class && superClass != NonStrictExpectations.class) {
            this.redefineFieldTypes(superClass, isTestClass);
        }
        Field[] fields = classWithMockFields.getDeclaredFields();
        DefaultResults defaultResults = TestRun.getExecutingTest().defaultResults;
        for (Field candidateField : fields) {
            int fieldModifiers = candidateField.getModifiers();
            if ((fieldModifiers & 0x1008) != 0) continue;
            if (candidateField.isAnnotationPresent(Input.class)) {
                defaultResults.add(candidateField, this.parentObject);
                continue;
            }
            this.field = candidateField;
            this.redefineFieldType(isTestClass, fieldModifiers);
            this.field = null;
        }
    }

    private void redefineFieldType(boolean fromTestClass, int modifiers) {
        this.typeMetadata = new MockedType(this.field, fromTestClass);
        if (this.typeMetadata.isMockField()) {
            this.finalField = Modifier.isFinal(modifiers);
            this.redefineTypeForMockField();
            ++this.typesRedefined;
            this.registerCaptureOfNewInstances();
        }
        this.typeMetadata = null;
    }

    protected abstract void redefineTypeForMockField();

    protected final void registerMockedClassIfNonStrict() {
        if (this.typeMetadata.nonStrict) {
            TestRun.getExecutingTest().addNonStrictMock(this.typeMetadata.getClassType());
        }
    }

    @Override
    public final CaptureOfNewInstancesForFields getCaptureOfNewInstances() {
        return (CaptureOfNewInstancesForFields)this.captureOfNewInstances;
    }

    private void registerCaptureOfNewInstances() {
        if (this.typeMetadata.getMaxInstancesToCapture() <= 0) {
            return;
        }
        if (this.captureOfNewInstances == null) {
            this.captureOfNewInstances = new CaptureOfNewInstancesForFields();
        }
        this.getCaptureOfNewInstances().registerCaptureOfNewInstances(this.typeMetadata, null);
    }

    public abstract boolean captureNewInstanceForApplicableMockField(Object var1);
}

