/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.util.ArrayList;
import java.util.List;
import mockit.external.asm.Attribute;
import mockit.external.asm.ClassReader;
import mockit.external.asm.FieldVisitor;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.commons.EmptyVisitor;
import mockit.internal.BaseClassModifier;
import mockit.internal.ClassFile;

final class InterfaceImplementationGenerator
extends BaseClassModifier {
    private final List<String> implementedMethods = new ArrayList<String>();
    private final String implementationClassName;
    private String interfaceName;
    private String[] initialSuperInterfaces;

    InterfaceImplementationGenerator(ClassReader classReader, String implementationClassName) {
        super(classReader);
        this.implementationClassName = implementationClassName.replace('.', '/');
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.interfaceName = name;
        this.initialSuperInterfaces = interfaces;
        String[] implementedInterfaces = new String[]{name};
        super.visit(version, 17, this.implementationClassName, signature, superName, implementedInterfaces);
        this.generateConstructor();
    }

    private void generateConstructor() {
        this.mw = super.visitMethod(1, "<init>", "()V", null, null);
        this.mw.visitVarInsn(25, 0);
        this.mw.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        this.generateEmptyImplementation();
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitSource(String file, String debug) {
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (name.charAt(0) != '<') {
            this.generateMethodImplementation(access, name, desc, signature, exceptions);
        }
        return null;
    }

    private void generateMethodImplementation(int access, String name, String desc, String signature, String[] exceptions) {
        String methodNameAndDesc = name + desc;
        if (!this.implementedMethods.contains(methodNameAndDesc)) {
            this.mw = super.visitMethod(1, name, desc, signature, exceptions);
            this.generateDirectCallToHandler(this.interfaceName, access, name, desc, signature, exceptions, 0);
            this.generateReturnWithObjectAtTopOfTheStack(desc);
            this.mw.visitMaxs(1, 0);
            this.implementedMethods.add(methodNameAndDesc);
        }
    }

    public void visitEnd() {
        for (String superInterface : this.initialSuperInterfaces) {
            new MethodGeneratorForImplementedSuperInterface(superInterface);
        }
    }

    private final class MethodGeneratorForImplementedSuperInterface
    extends EmptyVisitor {
        String[] superInterfaces;

        MethodGeneratorForImplementedSuperInterface(String interfaceName) {
            ClassFile.visitClass(interfaceName, this);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.superInterfaces = interfaces;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return null;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            InterfaceImplementationGenerator.this.generateMethodImplementation(access, name, desc, signature, exceptions);
            return null;
        }

        public void visitEnd() {
            for (String superInterface : this.superInterfaces) {
                new MethodGeneratorForImplementedSuperInterface(superInterface);
            }
        }
    }
}

