/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import mockit.Capturing;
import mockit.Cascading;
import mockit.Injectable;
import mockit.Mocked;
import mockit.NonStrict;
import mockit.internal.filtering.MockingConfiguration;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MockedType {
    @Mocked
    private static final Object DUMMY = null;
    private static final int DUMMY_HASHCODE;
    public final Field field;
    public final boolean fieldFromTestClass;
    private final int accessModifiers;
    private final Mocked mocked;
    public final Capturing capturing;
    final Cascading cascading;
    public final boolean nonStrict;
    public final boolean injectable;
    final Type declaredType;
    final String mockId;
    MockingConfiguration mockingCfg;

    MockedType(Field field, boolean fromTestClass) {
        this.field = field;
        this.fieldFromTestClass = fromTestClass;
        this.accessModifiers = field.getModifiers();
        this.mocked = field.getAnnotation(Mocked.class);
        this.capturing = field.getAnnotation(Capturing.class);
        this.cascading = field.getAnnotation(Cascading.class);
        this.nonStrict = field.isAnnotationPresent(NonStrict.class);
        this.injectable = field.isAnnotationPresent(Injectable.class);
        this.declaredType = field.getGenericType();
        this.mockId = field.getName();
        this.registerCascadingIfSpecified();
    }

    private void registerCascadingIfSpecified() {
        if (this.cascading != null) {
            String mockedTypeDesc = this.getClassType().getName().replace('.', '/');
            TestRun.getExecutingTest().addCascadingType(mockedTypeDesc, this.fieldFromTestClass);
        }
    }

    MockedType(int paramIndex, Type parameterType, Annotation[] annotationsOnParameter) {
        this.field = null;
        this.fieldFromTestClass = false;
        this.accessModifiers = 0;
        this.mocked = Utilities.getAnnotation(annotationsOnParameter, Mocked.class);
        this.capturing = Utilities.getAnnotation(annotationsOnParameter, Capturing.class);
        this.cascading = Utilities.getAnnotation(annotationsOnParameter, Cascading.class);
        this.nonStrict = Utilities.getAnnotation(annotationsOnParameter, NonStrict.class) != null;
        this.injectable = Utilities.getAnnotation(annotationsOnParameter, Injectable.class) != null;
        this.declaredType = parameterType;
        this.mockId = "param" + paramIndex;
        this.registerCascadingIfSpecified();
    }

    MockedType(Class<?> cascadedType) {
        this.field = null;
        this.fieldFromTestClass = false;
        this.accessModifiers = 0;
        this.mocked = null;
        this.capturing = null;
        this.cascading = null;
        this.nonStrict = true;
        this.injectable = true;
        this.declaredType = cascadedType;
        this.mockId = "cascaded_" + cascadedType.getName();
    }

    public Class<?> getClassType() {
        if (this.declaredType instanceof Class) {
            return (Class)this.declaredType;
        }
        if (this.declaredType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)this.declaredType;
            return (Class)parameterizedType.getRawType();
        }
        return null;
    }

    boolean isMockField() {
        boolean mock = this.mocked != null || this.capturing != null || this.cascading != null || this.nonStrict || this.injectable;
        return (mock || !this.fieldFromTestClass && !Modifier.isPrivate(this.accessModifiers)) && this.isMockableType();
    }

    private boolean isMockableType() {
        if (this.declaredType instanceof Class) {
            Class classType = (Class)this.declaredType;
            return !classType.isPrimitive() && !classType.isArray() && classType != Integer.class;
        }
        return true;
    }

    boolean isMockParameter() {
        return this.isMockableType();
    }

    boolean isFinalFieldOrParameter() {
        return this.field == null || Modifier.isFinal(this.accessModifiers);
    }

    void buildMockingConfiguration() {
        if (this.mocked == null) {
            return;
        }
        String[] filters = this.getFilters();
        if (filters.length > 0) {
            this.mockingCfg = new MockingConfiguration(filters, !this.mocked.inverse());
        }
    }

    private String[] getFilters() {
        String[] filters = this.mocked.methods();
        if (filters.length == 0) {
            filters = this.mocked.value();
        }
        return filters;
    }

    boolean isClassInitializationToBeStubbedOut() {
        return this.mocked != null && this.mocked.stubOutClassInitialization();
    }

    int getMaxInstancesToCapture() {
        if (this.capturing != null) {
            return this.capturing.maxInstances();
        }
        if (this.mocked != null) {
            return this.mocked.capture();
        }
        return 0;
    }

    String getRealClassName() {
        return this.mocked == null ? "" : this.mocked.realClassName();
    }

    public int hashCode() {
        int h;
        int result = this.declaredType.hashCode();
        if (Modifier.isFinal(this.accessModifiers)) {
            result *= 31;
        }
        if (this.injectable) {
            result *= 37;
        }
        if (this.mocked != null && (h = this.mocked.hashCode()) != DUMMY_HASHCODE) {
            result = 31 * result + h;
        }
        return result;
    }

    static {
        int h = 0;
        try {
            h = MockedType.class.getDeclaredField("DUMMY").getAnnotation(Mocked.class).hashCode();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        DUMMY_HASHCODE = h;
    }
}

