/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import mockit.external.asm.Type;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.expectations.mocking.TestedClassRedefinitions;
import mockit.internal.util.Utilities;

public final class TestedClassInstantiations {
    private final List<Field> testedFields;
    private final List<MockedType> injectableFields;

    TestedClassInstantiations(TestedClassRedefinitions redefinitions) {
        this.testedFields = redefinitions.testedFields;
        this.injectableFields = redefinitions.injectableFields;
    }

    public void assignNewInstancesToTestedFields(Object objectWithFields) {
        for (Field testedField : this.testedFields) {
            Object originalFieldValue = Utilities.getFieldValue(testedField, objectWithFields);
            if (originalFieldValue != null) continue;
            new TestedObjectCreation(objectWithFields, testedField).create();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TestedObjectCreation {
        final Object objectWithFields;
        final Field testedField;
        final Class<?> testedClass;
        Constructor<?> constructor;
        java.lang.reflect.Type[] parameterTypes;
        java.lang.reflect.Type declaredType;

        TestedObjectCreation(Object objectWithFields, Field testedField) {
            this.objectWithFields = objectWithFields;
            this.testedField = testedField;
            this.testedClass = testedField.getType();
        }

        void create() {
            this.findSingleConstructorAccordingToClassVisibility();
            if (this.constructor != null) {
                Object testedObject = this.instantiateUsingConstructor();
                this.injectIntoFieldsThatAreStillNull(this.testedClass, testedObject);
                Utilities.setFieldValue(this.testedField, this.objectWithFields, testedObject);
            }
        }

        private void findSingleConstructorAccordingToClassVisibility() {
            Constructor<?>[] constructors;
            if (Modifier.isPublic(this.testedClass.getModifiers()) && (constructors = this.testedClass.getConstructors()).length == 1) {
                this.constructor = constructors[0];
                return;
            }
            for (Constructor<?> c : constructors = this.testedClass.getDeclaredConstructors()) {
                if (c.getModifiers() != 0) continue;
                if (this.constructor == null) {
                    this.constructor = c;
                    continue;
                }
                this.constructor = null;
                return;
            }
        }

        private Object instantiateUsingConstructor() {
            this.parameterTypes = this.constructor.getGenericParameterTypes();
            Object[] arguments = this.obtainInjectedConstructorArguments();
            return Utilities.invoke(this.constructor, arguments);
        }

        private Object[] obtainInjectedConstructorArguments() {
            int n = this.parameterTypes.length;
            Object[] parameterValues = new Object[n];
            if (this.constructor.isVarArgs()) {
                --n;
            }
            for (int i = 0; i < n; ++i) {
                this.declaredType = this.parameterTypes[i];
                int position = this.findRelativePositionForInjectableField(i);
                parameterValues[i] = this.getArgumentValueToInject(position);
            }
            if (this.constructor.isVarArgs()) {
                parameterValues[n] = this.obtainInjectedValuesForVarargsParameter(n);
            }
            return parameterValues;
        }

        private Object obtainInjectedValuesForVarargsParameter(int varargsParameterIndex) {
            MockedType injectableField;
            this.declaredType = ((Class)this.parameterTypes[varargsParameterIndex]).getComponentType();
            int position = this.findRelativePositionForInjectableField(varargsParameterIndex) + 1;
            ArrayList<Object> varargValues = new ArrayList<Object>();
            while ((injectableField = this.findInjectableFieldForConstructorParameter(position)) != null) {
                Object value = this.getArgumentValueToInject(injectableField, position);
                varargValues.add(value);
                ++position;
            }
            int elementCount = varargValues.size();
            Object varargArray = Array.newInstance((Class)this.declaredType, elementCount);
            for (int i = 0; i < elementCount; ++i) {
                Array.set(varargArray, i, varargValues.get(i));
            }
            return varargArray;
        }

        private int findRelativePositionForInjectableField(int currentParameterIndex) {
            int pos = 0;
            for (int i = 0; i <= currentParameterIndex; ++i) {
                if (this.parameterTypes[i] != this.declaredType) continue;
                ++pos;
            }
            return pos;
        }

        private Object getArgumentValueToInject(int atPosition) {
            MockedType injectableField = this.findInjectableFieldForConstructorParameter(atPosition);
            if (injectableField == null) {
                throw new IllegalArgumentException("No injectable field" + this.missingFieldDescription(atPosition));
            }
            return this.getArgumentValueToInject(injectableField, atPosition);
        }

        private Object getArgumentValueToInject(MockedType injectableField, int atPosition) {
            Object argument = Utilities.getFieldValue(injectableField.field, this.objectWithFields);
            if (argument == null) {
                throw new IllegalArgumentException("No injectable value available" + this.missingFieldDescription(atPosition));
            }
            return argument;
        }

        private MockedType findInjectableFieldForConstructorParameter(int atPosition) {
            int currentPosition = 0;
            for (MockedType injectableField : TestedClassInstantiations.this.injectableFields) {
                if (injectableField.declaredType != this.declaredType || ++currentPosition != atPosition) continue;
                return injectableField;
            }
            return null;
        }

        private String missingFieldDescription(int position) {
            String typeDesc = this.declaredType.toString();
            if (this.declaredType instanceof Class) {
                Class declaredClass = (Class)this.declaredType;
                if (declaredClass.isArray()) {
                    typeDesc = "type " + Type.getType(declaredClass).getClassName();
                } else if (declaredClass.isPrimitive()) {
                    typeDesc = "type " + typeDesc;
                }
            }
            return " of " + typeDesc + " for " + position + "-th corresponding constructor parameter in " + this.testedClass;
        }

        private void injectIntoFieldsThatAreStillNull(Class<?> testedClass, Object tested) {
            Class<?> superClass = testedClass.getSuperclass();
            if (superClass != null && superClass.getProtectionDomain() == testedClass.getProtectionDomain()) {
                this.injectIntoFieldsThatAreStillNull(superClass, tested);
            }
            for (Field field : testedClass.getDeclaredFields()) {
                if (Utilities.getFieldValue(field, tested) != null) continue;
                Object value = this.getFieldValueIfAvailable(field);
                Utilities.setFieldValue(field, tested, value);
            }
        }

        private Object getFieldValueIfAvailable(Field fieldToBeInjected) {
            MockedType mockedType = this.findInjectableMockedType(fieldToBeInjected);
            return mockedType == null ? null : Utilities.getFieldValue(mockedType.field, this.objectWithFields);
        }

        private MockedType findInjectableMockedType(Field fieldToBeInjected) {
            this.declaredType = fieldToBeInjected.getGenericType();
            String fieldName = fieldToBeInjected.getName();
            boolean multipleFieldsOfSameTypeFound = false;
            MockedType found = null;
            for (MockedType injectableField : TestedClassInstantiations.this.injectableFields) {
                if (injectableField.declaredType != this.declaredType) continue;
                if (found == null) {
                    found = injectableField;
                    continue;
                }
                multipleFieldsOfSameTypeFound = true;
                if (!fieldName.equals(injectableField.field.getName())) continue;
                return injectableField;
            }
            if (multipleFieldsOfSameTypeFound && !fieldName.equals(found.field.getName())) {
                return null;
            }
            return found;
        }
    }
}

