/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.instrument.ClassDefinition;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import mockit.Tested;
import mockit.external.asm.ClassReader;
import mockit.internal.ClassFile;
import mockit.internal.RedefinitionEngine;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.expectations.mocking.TestedClassModifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TestedClassRedefinitions {
    final List<Field> testedFields = new LinkedList<Field>();
    final List<MockedType> injectableFields = new ArrayList<MockedType>();
    private final List<MockedType> mockedTypes = new ArrayList<MockedType>();

    TestedClassRedefinitions() {
    }

    boolean redefineTestedClasses(Object objectWithTestedFields) {
        for (Field field : objectWithTestedFields.getClass().getDeclaredFields()) {
            if (field.isAnnotationPresent(Tested.class)) {
                this.testedFields.add(field);
                continue;
            }
            MockedType mockedType = new MockedType(field, true);
            if (mockedType.injectable) {
                this.injectableFields.add(mockedType);
            }
            if (!mockedType.isMockField()) continue;
            this.mockedTypes.add(mockedType);
        }
        for (Field testedField : this.testedFields) {
            this.redefineTestedClass(testedField.getType());
        }
        return !this.testedFields.isEmpty();
    }

    private void redefineTestedClass(Class<?> testedClass) {
        ClassReader cr = ClassFile.createClassFileReader(testedClass.getName());
        TestedClassModifier modifier = new TestedClassModifier(cr, this.mockedTypes);
        cr.accept(modifier, false);
        byte[] modifiedClass = modifier.toByteArray();
        ClassDefinition classDefinition = new ClassDefinition(testedClass, modifiedClass);
        RedefinitionEngine.redefineClasses(classDefinition);
    }
}

