/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.filtering;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import mockit.external.asm.Type;
import mockit.internal.filtering.MockFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MockingConfiguration {
    private final List<MockFilter> filtersToApply;
    private final boolean desiredFilterResultWhenMatching;

    public MockingConfiguration(String[] filters, boolean desiredFilterResultWhenMatching) {
        this.filtersToApply = this.parseMockFilters(filters);
        this.desiredFilterResultWhenMatching = desiredFilterResultWhenMatching;
    }

    private List<MockFilter> parseMockFilters(String[] mockFilters) {
        ArrayList<MockFilter> filters = new ArrayList<MockFilter>(mockFilters.length);
        for (String mockFilter : mockFilters) {
            filters.add(new RegexMockFilter(mockFilter));
        }
        return filters;
    }

    public boolean matchesFilters(String name, String desc) {
        for (MockFilter filter : this.filtersToApply) {
            if (!filter.matches(name, desc)) continue;
            return this.desiredFilterResultWhenMatching;
        }
        return !this.desiredFilterResultWhenMatching;
    }

    private static final class RegexMockFilter
    implements MockFilter {
        private static final Pattern CONSTRUCTOR_NAME_REGEX = Pattern.compile("<init>");
        private static final String[] ANY_PARAMS = new String[0];
        private final Pattern nameRegex;
        private final String[] paramTypeNames;

        private RegexMockFilter(String filter) {
            int lp = filter.indexOf(40);
            int rp = filter.indexOf(41);
            if (lp < 0 && rp >= 0 || lp >= 0 && lp >= rp) {
                throw new IllegalArgumentException("Invalid filter: " + filter);
            }
            this.nameRegex = lp == 0 ? CONSTRUCTOR_NAME_REGEX : Pattern.compile(lp < 0 ? filter : filter.substring(0, lp));
            this.paramTypeNames = this.parseParameterTypes(filter, lp, rp);
        }

        private String[] parseParameterTypes(String filter, int lp, int rp) {
            if (lp < 0) {
                return ANY_PARAMS;
            }
            if (lp == rp - 1) {
                return null;
            }
            String[] typeNames = filter.substring(lp + 1, rp).split(",");
            for (int i = 0; i < typeNames.length; ++i) {
                typeNames[i] = typeNames[i].trim();
            }
            return typeNames;
        }

        public boolean matches(String name, String desc) {
            if (!this.nameRegex.matcher(name).matches()) {
                return false;
            }
            if (this.paramTypeNames == ANY_PARAMS) {
                return true;
            }
            if (this.paramTypeNames == null) {
                return desc.charAt(1) == ')';
            }
            Type[] argTypes = Type.getArgumentTypes(desc);
            if (argTypes.length != this.paramTypeNames.length) {
                return false;
            }
            for (int i = 0; i < this.paramTypeNames.length; ++i) {
                Type argType = argTypes[i];
                String paramTypeName = argType.getClassName();
                if (paramTypeName.endsWith(this.paramTypeNames[i])) continue;
                return false;
            }
            return true;
        }
    }
}

