/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.startup;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.List;
import sun.tools.attach.LinuxVirtualMachine;
import sun.tools.attach.WindowsVirtualMachine;

final class JDK6AgentLoader {
    private static final AttachProvider ATTACH_PROVIDER = new AttachProvider(){

        @Override
        public String name() {
            return null;
        }

        @Override
        public String type() {
            return null;
        }

        @Override
        public VirtualMachine attachVirtualMachine(String id) {
            return null;
        }

        @Override
        public List<VirtualMachineDescriptor> listVirtualMachines() {
            return null;
        }
    };
    private final String jarFilePath;
    private final String pid;

    JDK6AgentLoader(String jarFilePath) {
        this.jarFilePath = jarFilePath;
        this.pid = this.discoverProcessIdForRunningVM();
    }

    private String discoverProcessIdForRunningVM() {
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int p = nameOfRunningVM.indexOf(64);
        return nameOfRunningVM.substring(0, p);
    }

    void loadAgent() {
        VirtualMachine vm = AttachProvider.providers().isEmpty() ? this.getVirtualMachineImplementationFromEmbeddedOnes() : this.attachToThisVM();
        this.loadAgentAndDetachFromThisVM(vm);
    }

    private VirtualMachine getVirtualMachineImplementationFromEmbeddedOnes() {
        try {
            if (File.separatorChar == '\\') {
                return new WindowsVirtualMachine(ATTACH_PROVIDER, this.pid);
            }
            return new LinuxVirtualMachine(ATTACH_PROVIDER, this.pid);
        }
        catch (AttachNotSupportedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (UnsatisfiedLinkError e) {
            throw new IllegalStateException("Native library for Attach API not available in this JRE", e);
        }
    }

    private VirtualMachine attachToThisVM() {
        try {
            return VirtualMachine.attach(this.pid);
        }
        catch (AttachNotSupportedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadAgentAndDetachFromThisVM(VirtualMachine vm) {
        try {
            vm.loadAgent(this.jarFilePath, null);
            vm.detach();
        }
        catch (AgentLoadException e) {
            throw new RuntimeException(e);
        }
        catch (AgentInitializationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

