/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.startup;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import mockit.external.asm.ClassReader;
import mockit.integration.junit3.internal.JUnitTestCaseDecorator;
import mockit.integration.junit3.internal.TestSuiteDecorator;
import mockit.integration.junit4.internal.JUnit4TestRunnerDecorator;
import mockit.integration.junit4.internal.RunNotifierDecorator;
import mockit.integration.testng.internal.MockTestNG;
import mockit.internal.ClassFile;
import mockit.internal.MockingBridge;
import mockit.internal.RedefinitionEngine;
import mockit.internal.expectations.transformation.ExpectationsTransformer;
import mockit.internal.startup.AgentInitialization;
import mockit.internal.startup.JMockitTransformer;
import mockit.internal.startup.StartupConfiguration;
import mockit.internal.startup.ToolLoader;
import mockit.internal.state.TestRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Startup {
    static final String javaSpecVersion = System.getProperty("java.specification.version");
    static final boolean jdk6OrLater = "1.6".equals(javaSpecVersion) || "1.7".equals(javaSpecVersion);
    private static Instrumentation instrumentation;
    private static boolean initializedOnDemand;

    private Startup() {
    }

    public static boolean isJava6OrLater() {
        return jdk6OrLater;
    }

    public static void premain(String agentArgs, Instrumentation inst) throws Exception {
        Startup.initialize(true, agentArgs, inst);
    }

    public static void agentmain(String agentArgs, Instrumentation inst) throws Exception {
        Startup.initialize(false, agentArgs, inst);
    }

    private static void initialize(boolean initializeTestNG, String agentArgs, Instrumentation inst) throws IOException {
        instrumentation = inst;
        StartupConfiguration config = new StartupConfiguration();
        Startup.preventEventualClassLoadingConflicts();
        Startup.loadInternalStartupMocksForJUnitIntegration();
        if (initializeTestNG) {
            try {
                Startup.setUpInternalStartupMock(MockTestNG.class);
            }
            catch (Error ignored) {
                // empty catch block
            }
        }
        if (agentArgs != null && agentArgs.length() > 0) {
            Startup.processAgentArgs(config, agentArgs);
        }
        for (String toolSpec : config.defaultTools) {
            Startup.loadExternalTool(config, toolSpec, true);
        }
        inst.addTransformer(new JMockitTransformer());
        inst.addTransformer(new ExpectationsTransformer(inst));
    }

    private static void preventEventualClassLoadingConflicts() {
        try {
            Class.forName("mockit.Delegate");
            Class.forName("mockit.internal.expectations.invocation.InvocationResults");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        MockingBridge.MB.getClass();
    }

    private static void loadInternalStartupMocksForJUnitIntegration() {
        if (Startup.setUpInternalStartupMock(TestSuiteDecorator.class)) {
            try {
                Startup.setUpInternalStartupMock(JUnitTestCaseDecorator.class);
            }
            catch (VerifyError verifyError) {
                // empty catch block
            }
            Startup.setUpInternalStartupMock(RunNotifierDecorator.class);
            Startup.setUpInternalStartupMock(JUnit4TestRunnerDecorator.class);
            TestRun.mockFixture().turnRedefinedClassesIntoFixedOnes();
        }
    }

    private static boolean setUpInternalStartupMock(Class<?> mockClass) {
        try {
            new RedefinitionEngine(null, mockClass).setUpStartupMock();
            return true;
        }
        catch (TypeNotPresentException ignore) {
            return false;
        }
    }

    private static void processAgentArgs(StartupConfiguration config, String agentArgs) throws IOException {
        String[] externalToolSpecs;
        for (String toolSpec : externalToolSpecs = agentArgs.split("\\s*;\\s*")) {
            Startup.loadExternalTool(config, toolSpec, false);
        }
    }

    private static void loadExternalTool(StartupConfiguration config, String toolSpec, boolean byDefault) throws IOException {
        ClassReader cr;
        config.extractClassNameAndArgumentsFromToolSpecification(toolSpec, byDefault);
        if (byDefault) {
            try {
                cr = ClassFile.readClass(config.toolClassName);
            }
            catch (IOException ignore) {
                return;
            }
        } else {
            cr = ClassFile.readClass(config.toolClassName);
        }
        Startup.loadExternalTool(config, cr);
    }

    private static void loadExternalTool(StartupConfiguration config, ClassReader cr) {
        ToolLoader toolLoader = new ToolLoader(config.toolClassName, config.toolArguments);
        try {
            cr.accept(toolLoader, true);
        }
        catch (IllegalStateException ignore) {
            return;
        }
        System.out.println("JMockit: loaded external tool " + config);
    }

    public static Instrumentation instrumentation() {
        Startup.verifyInitialization();
        return instrumentation;
    }

    public static boolean wasInitializedOnDemand() {
        return initializedOnDemand;
    }

    public static void verifyInitialization() {
        if (instrumentation == null) {
            new AgentInitialization().initializeAccordingToJDKVersion();
            initializedOnDemand = true;
            System.out.println("WARNING: JMockit was initialized on demand, which may cause certain tests to fail;\nplease check the documentation for better ways to get it initialized.");
        }
    }

    public static boolean initializeIfNeeded() {
        if (instrumentation == null) {
            try {
                new AgentInitialization().initializeAccordingToJDKVersion();
                return true;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }
        return false;
    }

    public static void initializeIfPossible() {
        if (jdk6OrLater) {
            Startup.initializeIfNeeded();
        }
    }
}

