/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import mockit.Input;
import mockit.external.asm.Type;
import mockit.internal.util.DefaultValues;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultResults {
    private Map<String, ResultExtractor> defaultResults;

    public void add(Field inputField, Object fieldOwner) {
        Class<?> fieldType = inputField.getType();
        String resultTypeDesc = Exception.class.isAssignableFrom(fieldType) ? Type.getInternalName(fieldType) : this.getReturnTypeDescriptor(inputField, fieldType);
        this.addExtractor(resultTypeDesc, new ResultExtractor(inputField, fieldOwner));
    }

    private String getReturnTypeDescriptor(Field inputField, Class<?> fieldType) {
        String returnTypeDesc = (String)Utilities.invoke(Field.class, (Object)inputField, "getGenericSignature", new Object[0]);
        if (returnTypeDesc == null) {
            returnTypeDesc = Type.getDescriptor(fieldType);
        }
        return returnTypeDesc;
    }

    private void addExtractor(String resultTypeDesc, ResultExtractor resultExtractor) {
        ResultExtractor previousExtractor;
        if (this.defaultResults == null) {
            this.defaultResults = new HashMap<String, ResultExtractor>();
        }
        if ((previousExtractor = this.defaultResults.get(resultTypeDesc)) == null) {
            this.defaultResults.put(resultTypeDesc, resultExtractor);
        } else {
            previousExtractor.chainNextOne(resultExtractor);
        }
    }

    public Object get(String signature, String[] exceptions) {
        String returnTypeDesc;
        int typeParameter;
        ResultExtractor extractor;
        if (this.defaultResults == null) {
            return null;
        }
        if (exceptions != null) {
            for (String exception : exceptions) {
                extractor = this.defaultResults.get(exception);
                if (extractor == null) continue;
                extractor.extractException();
            }
        }
        extractor = (typeParameter = (returnTypeDesc = DefaultValues.getReturnTypeDesc(signature)).indexOf("<T")) < 0 ? this.defaultResults.get(returnTypeDesc) : this.findResultForGenericType(typeParameter);
        return extractor == null ? null : extractor.getInputFieldValue();
    }

    private ResultExtractor findResultForGenericType(int typeParamPos) {
        for (Map.Entry<String, ResultExtractor> keyAndValue : this.defaultResults.entrySet()) {
            String key = keyAndValue.getKey();
            if (key.length() <= typeParamPos || key.charAt(typeParamPos) != '<' || key.indexOf(59, typeParamPos) <= 0) continue;
            return keyAndValue.getValue();
        }
        return null;
    }

    void clear() {
        this.defaultResults = null;
    }

    private final class ResultExtractor {
        final Field inputField;
        final Object fieldOwner;
        ResultExtractor next;
        volatile int invocationsRemaining;
        volatile Object valueCache;

        ResultExtractor(Field inputField, Object fieldOwner) {
            this.inputField = inputField;
            this.fieldOwner = fieldOwner;
            this.invocationsRemaining = inputField.getAnnotation(Input.class).invocations();
        }

        void chainNextOne(ResultExtractor next) {
            this.next = next;
            if (this.invocationsRemaining == Integer.MAX_VALUE) {
                this.invocationsRemaining = 1;
            }
        }

        void extractException() {
            Object exception = this.getInputFieldValue();
            Utilities.throwCheckedException((Exception)exception);
        }

        Object getInputFieldValue() {
            if (this.invocationsRemaining <= 0) {
                return this.next == null ? null : this.next.getInputFieldValue();
            }
            --this.invocationsRemaining;
            Object valueFromCache = this.valueCache;
            if (valueFromCache != null) {
                return valueFromCache;
            }
            Object fieldValue = Utilities.getFieldValue(this.inputField, this.fieldOwner);
            if (fieldValue == null) {
                fieldValue = Utilities.newInstanceUsingDefaultConstructor(this.inputField.getType());
            }
            this.valueCache = fieldValue;
            return fieldValue;
        }
    }
}

