/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import mockit.Invocation;
import mockit.internal.annotations.AnnotatedMockStates;
import mockit.internal.capturing.CaptureOfImplementationsForTestClass;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.mocking.SharedFieldTypeRedefinitions;
import mockit.internal.state.ExecutingTest;
import mockit.internal.state.MockClasses;
import mockit.internal.state.MockFixture;
import mockit.internal.state.ProxyClasses;
import mockit.internal.state.SavePoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestRun {
    private static final TestRun STARTUP_INSTANCE = new TestRun();
    private static final Map<ClassLoader, TestRun> INSTANCES = Collections.synchronizedMap(new HashMap());
    private static final ThreadLocal<Integer> noMockingCount;
    private int testId;
    private Class<?> currentTestClass;
    private Object currentTestInstance;
    private Method runningTestMethod;
    private SavePoint savePointForTestClass;
    private CaptureOfImplementationsForTestClass captureOfSubtypes;
    private SharedFieldTypeRedefinitions sharedFieldTypeRedefinitions;
    private final ProxyClasses proxyClasses = new ProxyClasses();
    private final MockFixture mockFixture = new MockFixture();
    private final ExecutingTest executingTest = new ExecutingTest();
    private final MockClasses mockClasses = new MockClasses();

    private static TestRun getInstance() {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        TestRun instance = INSTANCES.get(contextCL);
        if (instance == null) {
            instance = INSTANCES.get(contextCL.getParent());
        }
        if (instance == null) {
            instance = new TestRun();
            INSTANCES.put(contextCL, instance);
        }
        return instance;
    }

    private TestRun() {
    }

    public static boolean isInsideNoMockingZone() {
        return noMockingCount.get() > 0;
    }

    public static Class<?> getCurrentTestClass() {
        return TestRun.getInstance().currentTestClass;
    }

    public static Object getCurrentTestInstance() {
        return TestRun.getInstance().currentTestInstance;
    }

    public static int getTestId() {
        return TestRun.getInstance().testId;
    }

    public static SavePoint getSavePointForTestClass() {
        return TestRun.getInstance().savePointForTestClass;
    }

    public static CaptureOfImplementationsForTestClass getCaptureOfSubtypes() {
        return TestRun.getInstance().captureOfSubtypes;
    }

    public static SharedFieldTypeRedefinitions getSharedFieldTypeRedefinitions() {
        return TestRun.getInstance().sharedFieldTypeRedefinitions;
    }

    public static ProxyClasses proxyClasses() {
        return TestRun.getInstance().proxyClasses;
    }

    public static MockFixture mockFixture() {
        return TestRun.getInstance().mockFixture;
    }

    public static ExecutingTest getExecutingTest() {
        return TestRun.getInstance().executingTest;
    }

    public static RecordAndReplayExecution getRecordAndReplayForRunningTest(boolean create) {
        TestRun testRun = TestRun.getInstance();
        if (testRun.currentTestInstance == null) {
            return null;
        }
        return testRun.executingTest.getRecordAndReplay(testRun.runningTestMethod != null && create);
    }

    public static MockClasses getMockClasses() {
        return TestRun.getInstance().mockClasses;
    }

    public static void verifyExpectationsOnAnnotatedMocks() {
        TestRun.getMockClasses().getMockStates().verifyExpectations();
    }

    public static void resetExpectationsOnAnnotatedMocks() {
        TestRun.getMockClasses().getMockStates().resetExpectations();
    }

    public static void setCurrentTestClass(Class<?> testClass) {
        TestRun.getInstance().currentTestClass = testClass;
    }

    public static void prepareForNextTest() {
        ++TestRun.getInstance().testId;
    }

    public static void setRunningTestMethod(Method runningTestMethod) {
        TestRun testRun = TestRun.getInstance();
        testRun.runningTestMethod = runningTestMethod;
        if (runningTestMethod != null) {
            testRun.executingTest.clearRecordAndReplayForVerifications();
        }
    }

    public static void enterNoMockingZone() {
        noMockingCount.set(1);
    }

    public static void exitNoMockingZone() {
        noMockingCount.set(-1);
    }

    public static void setRunningIndividualTest(Object testInstance) {
        TestRun.getInstance().currentTestInstance = testInstance;
    }

    public static void setSavePointForTestClass(SavePoint savePoint) {
        TestRun.getInstance().savePointForTestClass = savePoint;
    }

    public static void setCaptureOfSubtypes(CaptureOfImplementationsForTestClass captureOfSubtypes) {
        TestRun.getInstance().captureOfSubtypes = captureOfSubtypes;
    }

    public static void setSharedFieldTypeRedefinitions(SharedFieldTypeRedefinitions redefinitions) {
        TestRun.getInstance().sharedFieldTypeRedefinitions = redefinitions;
    }

    public static void finishCurrentTestExecution(boolean clearSharedMocks) {
        TestRun testRun = TestRun.getInstance();
        testRun.runningTestMethod = null;
        testRun.executingTest.finishExecution(clearSharedMocks);
    }

    public static Object getMock(int index) {
        return TestRun.getMockClasses().regularMocks.getMock(index);
    }

    public static Object getStartupMock(int index) {
        return TestRun.STARTUP_INSTANCE.mockClasses.startupMocks.getMock(index);
    }

    public static Object getMock(Class<?> mockClass, Object mockedInstance) {
        return TestRun.getMockClasses().regularMocks.getMock(mockClass, mockedInstance);
    }

    public static boolean updateMockState(String mockClassDesc, int mockStateIndex) {
        AnnotatedMockStates mockStates = TestRun.getMockStates(mockClassDesc);
        return mockStates.updateMockState(mockClassDesc, mockStateIndex);
    }

    private static AnnotatedMockStates getMockStates(String mockClassDesc) {
        AnnotatedMockStates mockStates = TestRun.getMockClasses().getMockStates();
        return mockStates.hasStates(mockClassDesc) ? mockStates : TestRun.STARTUP_INSTANCE.mockClasses.getMockStates();
    }

    public static void exitReentrantMock(String mockClassDesc, int mockStateIndex) {
        AnnotatedMockStates mockStates = TestRun.getMockStates(mockClassDesc);
        mockStates.exitReentrantMock(mockClassDesc, mockStateIndex);
    }

    public static Invocation createMockInvocation(String mockClassDesc, int mockStateIndex, Object mockedInstance) {
        AnnotatedMockStates mockStates = TestRun.getMockStates(mockClassDesc);
        return mockStates.createMockInvocation(mockClassDesc, mockStateIndex, mockedInstance);
    }

    static {
        INSTANCES.put(ClassLoader.getSystemClassLoader(), STARTUP_INSTANCE);
        noMockingCount = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }

            @Override
            public void set(Integer valueToAdd) {
                super.set((Integer)this.get() + valueToAdd);
            }
        };
    }
}

