/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodFormatter {
    private final StringBuilder out = new StringBuilder();
    private String classDesc;
    private String methodDesc;
    private int typeDescPos;
    private char typeCode;
    private int arrayDimensions;

    public MethodFormatter() {
    }

    public MethodFormatter(String classDesc, String methodDesc) {
        this();
        this.classDesc = classDesc;
        this.methodDesc = methodDesc;
        this.appendFriendlyMethodSignature();
    }

    public String toString() {
        return this.out.toString();
    }

    public String friendlyMethodSignatures(Collection<String> classAndMethodDescs) {
        String sep = "";
        for (String classAndMethodDesc : classAndMethodDescs) {
            this.out.append(sep);
            this.separateClassAndMethodInternalDescriptions(classAndMethodDesc);
            this.appendFriendlyMethodSignature();
            sep = ",\n";
        }
        return this.out.toString();
    }

    private void appendFriendlyMethodSignature() {
        String className = null;
        String friendlyDesc = this.methodDesc;
        if (this.classDesc != null) {
            className = this.classDesc.replace('/', '.');
            String constructorName = this.getConstructorName(className);
            friendlyDesc = friendlyDesc.replace("<init>", constructorName);
        }
        int leftParenPos = friendlyDesc.indexOf(40);
        int rightParenPos = friendlyDesc.indexOf(41);
        if (!this.methodDesc.startsWith("<init>")) {
            String returnType = friendlyDesc.substring(rightParenPos + 1);
            this.appendFriendlyTypes(returnType);
            this.out.append(' ');
        }
        if (className != null) {
            this.out.append(className).append('#');
        }
        if (leftParenPos + 1 < rightParenPos) {
            this.out.append(friendlyDesc.substring(0, leftParenPos + 1));
            String parameterTypes = friendlyDesc.substring(leftParenPos + 1, rightParenPos);
            this.appendFriendlyTypes(parameterTypes);
            this.out.append(')');
        } else {
            this.out.append(friendlyDesc.substring(0, rightParenPos + 1));
        }
    }

    private String getConstructorName(String className) {
        int p = className.lastIndexOf(46);
        String constructorName = p < 0 ? className : className.substring(p + 1);
        p = constructorName.lastIndexOf(36);
        if (p > 0) {
            constructorName = constructorName.substring(p + 1);
        }
        return constructorName;
    }

    private void separateClassAndMethodInternalDescriptions(String classAndMethodDesc) {
        int p = classAndMethodDesc.indexOf(35);
        if (p >= 0) {
            this.classDesc = classAndMethodDesc.substring(0, p);
            this.methodDesc = classAndMethodDesc.substring(p + 1);
        } else {
            this.classDesc = null;
            this.methodDesc = classAndMethodDesc;
        }
    }

    private void appendFriendlyTypes(String typeDescs) {
        String sep = "";
        for (String typeDesc : typeDescs.split(";")) {
            this.out.append(sep);
            if (typeDesc.charAt(0) == 'L') {
                this.out.append(this.friendlyReferenceType(typeDesc));
            } else {
                this.appendFriendlyPrimitiveTypes(typeDesc);
            }
            sep = ", ";
        }
    }

    private String friendlyReferenceType(String typeDesc) {
        return typeDesc.substring(1).replace("java/lang/", "").replace('/', '.');
    }

    private void appendFriendlyPrimitiveTypes(String typeDesc) {
        String sep = "";
        this.typeDescPos = 0;
        while (this.typeDescPos < typeDesc.length()) {
            this.typeCode = typeDesc.charAt(this.typeDescPos);
            this.advancePastArrayDimensionsIfAny(typeDesc);
            String paramType = this.getTypeNameForTypeDesc(typeDesc);
            this.out.append(sep).append(paramType);
            this.appendArrayBrackets();
            sep = ", ";
            ++this.typeDescPos;
        }
    }

    private String getTypeNameForTypeDesc(String typeDesc) {
        String paramType;
        switch (this.typeCode) {
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
            case 'L': {
                paramType = this.friendlyReferenceType(typeDesc.substring(this.typeDescPos));
                this.typeDescPos = typeDesc.length();
                break;
            }
            default: {
                paramType = typeDesc.substring(this.typeDescPos);
                this.typeDescPos = typeDesc.length();
            }
        }
        return paramType;
    }

    private void advancePastArrayDimensionsIfAny(String param) {
        this.arrayDimensions = 0;
        while (this.typeCode == '[') {
            ++this.typeDescPos;
            this.typeCode = param.charAt(this.typeDescPos);
            ++this.arrayDimensions;
        }
    }

    private void appendArrayBrackets() {
        for (int i = 0; i < this.arrayDimensions; ++i) {
            this.out.append("[]");
        }
    }
}

