/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mockit.external.asm.ClassReader;
import mockit.external.asm.FieldVisitor;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.commons.EmptyVisitor;
import mockit.internal.ClassFile;
import mockit.internal.util.VisitInterruptedException;

public final class SuperConstructorCollector
extends EmptyVisitor {
    public static final SuperConstructorCollector INSTANCE = new SuperConstructorCollector();
    private final Map<String, String> cache = new HashMap<String, String>();
    private String constructorDesc;

    private SuperConstructorCollector() {
    }

    public synchronized String findConstructor(String className) {
        this.constructorDesc = this.cache.get(className);
        if (this.constructorDesc != null) {
            return this.constructorDesc;
        }
        ClassReader cr = this.createClassReader(className);
        try {
            cr.accept(this, true);
        }
        catch (VisitInterruptedException visitInterruptedException) {
            // empty catch block
        }
        this.cache.put(className, this.constructorDesc);
        return this.constructorDesc;
    }

    private ClassReader createClassReader(String className) {
        try {
            return ClassFile.readClass(className);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read class file for " + className, e);
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ("<init>".equals(name)) {
            this.constructorDesc = desc;
            throw VisitInterruptedException.INSTANCE;
        }
        return null;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return null;
    }
}

