/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import mockit.Invocation;
import mockit.internal.util.DefaultValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utilities {
    public static final String GENERATED_SUBCLASS_PREFIX = "$Subclass_";
    public static final String GENERATED_IMPLCLASS_PREFIX = "$Impl_";
    public static final Object[] NO_ARGS = new Object[0];
    private static final Class<?>[] PRIMITIVE_TYPES = new Class[]{null, Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Long.TYPE, Double.TYPE};
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE = new HashMap<Class<?>, Class<?>>(){
        {
            this.put(Boolean.class, Boolean.TYPE);
            this.put(Character.class, Character.TYPE);
            this.put(Byte.class, Byte.TYPE);
            this.put(Short.class, Short.TYPE);
            this.put(Integer.class, Integer.TYPE);
            this.put(Float.class, Float.TYPE);
            this.put(Long.class, Long.TYPE);
            this.put(Double.class, Double.TYPE);
        }
    };
    private static final Class<?>[] NO_PARAMETERS = new Class[0];

    private Utilities() {
    }

    public static <T> Class<T> loadClass(String className) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            return Class.forName(className, true, loader);
        }
        catch (LinkageError e) {
            e.printStackTrace();
            throw e;
        }
        catch (ClassNotFoundException ignore) {
            throw new IllegalArgumentException("No class with name \"" + className + "\" found");
        }
    }

    public static <T> T newInstance(Class<T> aClass) {
        return Utilities.newInstance(aClass, (Object[])NO_PARAMETERS);
    }

    public static <T> T newInstance(Class<T> aClass, Class<?>[] parameterTypes, Object ... initArgs) {
        Constructor<?> constructor = Utilities.findSpecifiedConstructor(aClass, parameterTypes);
        return (T)Utilities.invoke(constructor, initArgs);
    }

    private static Constructor<?> findSpecifiedConstructor(Class<?> theClass, Class<?>[] paramTypes) {
        for (Constructor<?> declaredConstructor : theClass.getDeclaredConstructors()) {
            if (!Utilities.matchesParameterTypes(declaredConstructor.getParameterTypes(), paramTypes)) continue;
            return declaredConstructor;
        }
        String paramTypesDesc = Utilities.getParameterTypesDescription(paramTypes);
        throw new IllegalArgumentException("Specified constructor not found: " + theClass.getSimpleName() + paramTypesDesc);
    }

    private static String getParameterTypesDescription(Type[] paramTypes) {
        String paramTypesDesc = Arrays.asList(paramTypes).toString();
        return paramTypesDesc.replace("class ", "").replace('[', '(').replace(']', ')');
    }

    public static <T> T newInstance(String className, Class<?>[] parameterTypes, Object ... initArgs) {
        Class<T> theClass = Utilities.loadClass(className);
        return Utilities.newInstance(theClass, parameterTypes, initArgs);
    }

    public static <T> T newInstance(Class<? extends T> aClass, Object ... nonNullArgs) {
        Class<?>[] argTypes = Utilities.getArgumentTypesFromArgumentValues(nonNullArgs);
        Constructor constructor = Utilities.findCompatibleConstructor(aClass, argTypes);
        return (T)Utilities.invoke(constructor, nonNullArgs);
    }

    private static Constructor findCompatibleConstructor(Class<?> theClass, Class<?>[] argTypes) {
        for (Constructor<?> declaredConstructor : theClass.getDeclaredConstructors()) {
            Class<?>[] declaredParamTypes = declaredConstructor.getParameterTypes();
            if (!Utilities.matchesParameterTypes(declaredParamTypes, argTypes) && !Utilities.acceptsArgumentTypes(declaredParamTypes, argTypes)) continue;
            return declaredConstructor;
        }
        String argTypesDesc = Utilities.getParameterTypesDescription(argTypes);
        throw new IllegalArgumentException("No compatible constructor found: " + theClass.getSimpleName() + argTypesDesc);
    }

    public static <T> T newInstance(String className, Object ... nonNullArgs) {
        Class<?>[] argTypes = Utilities.getArgumentTypesFromArgumentValues(nonNullArgs);
        return Utilities.newInstance(className, argTypes, nonNullArgs);
    }

    private static Class<?>[] getArgumentTypesFromArgumentValues(Object ... args) {
        if (args.length == 0) {
            return NO_PARAMETERS;
        }
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = Utilities.getArgumentTypeFromArgumentValue(i, args);
        }
        return argTypes;
    }

    private static Class<?> getArgumentTypeFromArgumentValue(int i, Object[] args) {
        Class<?> argType;
        Object arg = args[i];
        if (arg == null) {
            throw new IllegalArgumentException("Invalid null value passed as argument " + i + " (instead of null, provide the Class object for the parameter type)");
        }
        if (arg instanceof Class) {
            argType = (Class<?>)arg;
            args[i] = null;
        } else {
            Class<?> argClass = arg.getClass();
            argType = Utilities.isGeneratedImplementationClass(argClass) ? argClass.getInterfaces()[0] : Utilities.getMockedClass(argClass);
        }
        return argType;
    }

    public static boolean isGeneratedImplementationClass(Class<?> mockedType) {
        return Proxy.isProxyClass(mockedType) || Utilities.isGeneratedImplementationClass(mockedType.getName());
    }

    public static Class<?> getMockedClass(Class<?> aClass) {
        return Utilities.isGeneratedSubclass(aClass.getName()) ? aClass.getSuperclass() : aClass;
    }

    public static Class<?> getMockedClass(Object mock) {
        return Utilities.getMockedClass(mock.getClass());
    }

    private static boolean isGeneratedSubclass(String className) {
        return className.contains(GENERATED_SUBCLASS_PREFIX);
    }

    private static boolean isGeneratedImplementationClass(String className) {
        return className.contains(GENERATED_IMPLCLASS_PREFIX);
    }

    public static boolean isGeneratedClass(String className) {
        return Utilities.isGeneratedSubclass(className) || Utilities.isGeneratedImplementationClass(className);
    }

    public static <T> T newInnerInstance(Class<? extends T> innerClass, Object outerInstance, Object ... nonNullArgs) {
        Object[] initArgs = Utilities.argumentsWithExtraFirstValue(nonNullArgs, outerInstance);
        return Utilities.newInstance(innerClass, initArgs);
    }

    public static Object[] argumentsWithExtraFirstValue(Object[] args, Object firstValue) {
        Object[] args2 = new Object[1 + args.length];
        args2[0] = firstValue;
        System.arraycopy(args, 0, args2, 1, args.length);
        return args2;
    }

    public static <T> T newInnerInstance(String innerClassName, Object outerInstance, Object ... nonNullArgs) {
        String className = outerInstance.getClass().getName() + '$' + innerClassName;
        Class<T> innerClass = Utilities.loadClass(className);
        return Utilities.newInnerInstance(innerClass, outerInstance, nonNullArgs);
    }

    public static <T> T invoke(Class<?> theClass, Object targetInstance, String methodName, Object ... methodArgs) {
        Class<?>[] argTypes = Utilities.getArgumentTypesFromArgumentValues(methodArgs);
        Method method = Utilities.findCompatibleMethod(theClass, methodName, argTypes);
        if (targetInstance == null && !Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Attempted to invoke non-static method without an instance to invoke it on");
        }
        T result = Utilities.invoke(targetInstance, method, methodArgs);
        return result;
    }

    public static Method findCompatibleMethod(Object targetInstance, String methodName, Object[] args) {
        Class<?>[] argTypes = Utilities.getArgumentTypesFromArgumentValues(args);
        return Utilities.findCompatibleMethod(targetInstance.getClass(), methodName, argTypes);
    }

    private static Method findCompatibleMethod(Class<?> theClass, String methodName, Class<?>[] argTypes) {
        while (true) {
            Method methodFound;
            if ((methodFound = Utilities.findCompatibleMethodInClass(theClass, methodName, argTypes)) != null) {
                return methodFound;
            }
            Class<?> superClass = theClass.getSuperclass();
            if (superClass == null || superClass == Object.class) break;
            theClass = superClass;
        }
        String argTypesDesc = Utilities.getParameterTypesDescription(argTypes);
        throw new IllegalArgumentException("No compatible method found: " + methodName + argTypesDesc);
    }

    private static Method findCompatibleMethodInClass(Class<?> theClass, String methodName, Class<?>[] argTypes) {
        for (Method declaredMethod : theClass.getDeclaredMethods()) {
            Class<?>[] declaredParamTypes;
            if (!declaredMethod.getName().equals(methodName) || !Utilities.matchesParameterTypes(declaredParamTypes = declaredMethod.getParameterTypes(), argTypes) && !Utilities.acceptsArgumentTypes(declaredParamTypes, argTypes)) continue;
            return declaredMethod;
        }
        return null;
    }

    private static boolean acceptsArgumentTypes(Class<?>[] paramTypes, Class<?>[] argTypes) {
        int i0 = 0;
        if (paramTypes.length != argTypes.length) {
            if (paramTypes.length > 0 && paramTypes[0] == Invocation.class) {
                i0 = 1;
            } else {
                return false;
            }
        }
        for (int i = i0; i < paramTypes.length; ++i) {
            Class<?> parType = paramTypes[i];
            Class<?> argType = argTypes[i - i0];
            if (Utilities.isSameTypeIgnoringAutoBoxing(parType, argType) || parType.isAssignableFrom(argType)) continue;
            return false;
        }
        return true;
    }

    public static Method findNonPrivateHandlerMethod(Object handler) {
        Method[] declaredMethods = handler.getClass().getDeclaredMethods();
        Method nonPrivateMethod = null;
        for (Method declaredMethod : declaredMethods) {
            if (Modifier.isPrivate(declaredMethod.getModifiers())) continue;
            if (nonPrivateMethod != null) {
                throw new IllegalArgumentException("More than one non-private invocation handler method found");
            }
            nonPrivateMethod = declaredMethod;
        }
        if (nonPrivateMethod == null) {
            throw new IllegalArgumentException("No non-private invocation handler method found");
        }
        return nonPrivateMethod;
    }

    public static <T> T invoke(Class<?> theClass, Object targetInstance, String methodName, Class<?>[] paramTypes, Object ... methodArgs) {
        Method method = Utilities.findSpecifiedMethod(theClass, methodName, paramTypes);
        T result = Utilities.invoke(targetInstance, method, methodArgs);
        return result;
    }

    public static <T> T invoke(Object targetInstance, Method method, Object ... methodArgs) {
        Utilities.ensureThatMemberIsAccessible(method);
        try {
            return (T)method.invoke(targetInstance, methodArgs);
        }
        catch (IllegalAccessException e) {
            assert (false) : "Not expected to happen because the method was made accessible";
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            Utilities.filterStackTrace(e);
            throw new IllegalArgumentException("Failure to invoke method: " + method, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            Utilities.throwCheckedException((Exception)cause);
            return null;
        }
    }

    private static void ensureThatMemberIsAccessible(AccessibleObject classMember) {
        if (!classMember.isAccessible()) {
            classMember.setAccessible(true);
        }
    }

    private static Method findSpecifiedMethod(Class<?> theClass, String methodName, Class<?>[] paramTypes) {
        for (Method declaredMethod : theClass.getDeclaredMethods()) {
            if (!declaredMethod.getName().equals(methodName) || !Utilities.matchesParameterTypes(declaredMethod.getParameterTypes(), paramTypes)) continue;
            return declaredMethod;
        }
        Class<?> superClass = theClass.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return Utilities.findSpecifiedMethod(superClass, methodName, paramTypes);
        }
        String paramTypesDesc = Utilities.getParameterTypesDescription(paramTypes);
        throw new IllegalArgumentException("Specified method not found: " + methodName + paramTypesDesc);
    }

    private static boolean matchesParameterTypes(Class<?>[] declaredTypes, Class<?>[] specifiedTypes) {
        int i0 = 0;
        if (declaredTypes.length != specifiedTypes.length) {
            if (declaredTypes.length > 0 && declaredTypes[0] == Invocation.class) {
                i0 = 1;
            } else {
                return false;
            }
        }
        for (int i = i0; i < declaredTypes.length; ++i) {
            Class<?> declaredType = declaredTypes[i];
            Class<?> specifiedType = specifiedTypes[i - i0];
            if (Utilities.isSameTypeIgnoringAutoBoxing(declaredType, specifiedType)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSameTypeIgnoringAutoBoxing(Class<?> firstType, Class<?> secondType) {
        return firstType == secondType || firstType.isPrimitive() && Utilities.isWrapperOfPrimitiveType(firstType, secondType) || secondType.isPrimitive() && Utilities.isWrapperOfPrimitiveType(secondType, firstType);
    }

    private static boolean isWrapperOfPrimitiveType(Class<?> primitiveType, Class<?> otherType) {
        return primitiveType == WRAPPER_TO_PRIMITIVE.get(otherType);
    }

    public static boolean isWrapperOfPrimitiveType(Class<?> type) {
        return WRAPPER_TO_PRIMITIVE.containsKey(type);
    }

    public static Method findPublicVoidMethod(Class<?> aClass, String methodName) {
        for (Method method : aClass.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || method.getReturnType() != Void.TYPE || !methodName.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    private static Object[] getDefaultParameterValues(Constructor<?> constructor) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        int numParameters = parameterTypes.length;
        Object[] defaultArgs = new Object[numParameters];
        for (int i = 0; i < numParameters; ++i) {
            Class<?> paramType = parameterTypes[i];
            defaultArgs[i] = DefaultValues.computeForType(paramType);
        }
        return defaultArgs;
    }

    public static Object invoke(Constructor<?> constructor, Object ... initArgs) {
        Utilities.ensureThatMemberIsAccessible(constructor);
        Object[] args = initArgs != null ? initArgs : Utilities.getDefaultParameterValues(constructor);
        try {
            return constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            assert (false) : "Not expected to happen because the class is expected to be concrete";
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            assert (false) : "Not expected to happen because the constructor was made accessible";
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            Utilities.throwCheckedException((Exception)cause);
            return null;
        }
    }

    public static Object getField(Class<?> theClass, String fieldName, Object targetObject) {
        Field field = Utilities.getDeclaredField(theClass, fieldName);
        return Utilities.getFieldValue(field, targetObject);
    }

    public static Field getDeclaredField(Class<?> theClass, String fieldName) {
        try {
            return theClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException ignore) {
            Class<?> superClass = theClass.getSuperclass();
            if (superClass != null) {
                return Utilities.getDeclaredField(superClass, fieldName);
            }
            throw new IllegalArgumentException("No instance field of name \"" + fieldName + "\" found in " + theClass);
        }
    }

    public static <T> T getField(Class<?> theClass, Class<T> fieldType, Object targetObject) {
        Field field = Utilities.getDeclaredField(theClass, fieldType, targetObject != null, false);
        return (T)Utilities.getFieldValue(field, targetObject);
    }

    public static <T> T getField(Class<?> theClass, Type fieldType, Object targetObject) {
        Field field = Utilities.getDeclaredField(theClass, fieldType, targetObject != null, false);
        return (T)Utilities.getFieldValue(field, targetObject);
    }

    private static Field getDeclaredField(Class<?> theClass, Type desiredType, boolean instanceField, boolean forAssignment) {
        Field found = Utilities.getDeclaredFieldInSingleClass(theClass, desiredType, instanceField, forAssignment);
        if (found == null) {
            Class<?> superClass = theClass.getSuperclass();
            if (superClass != null && superClass != Object.class) {
                return Utilities.getDeclaredField(superClass, desiredType, instanceField, forAssignment);
            }
            throw new IllegalArgumentException((instanceField ? "Instance" : "Static") + " field of " + desiredType + " not found in " + theClass);
        }
        return found;
    }

    private static Field getDeclaredFieldInSingleClass(Class<?> theClass, Type desiredType, boolean instanceField, boolean forAssignment) {
        Field found = null;
        for (Field field : theClass.getDeclaredFields()) {
            if (field.isSynthetic()) continue;
            Type fieldType = field.getGenericType();
            if (instanceField == Modifier.isStatic(field.getModifiers()) || !Utilities.isCompatibleFieldType(fieldType, desiredType, forAssignment)) continue;
            if (found != null) {
                String message = Utilities.errorMessageForMoreThanOneFieldFound(desiredType, instanceField, forAssignment, found, field);
                throw new IllegalArgumentException(message);
            }
            found = field;
        }
        return found;
    }

    private static String errorMessageForMoreThanOneFieldFound(Type desiredFieldType, boolean instanceField, boolean forAssignment, Field firstField, Field secondField) {
        StringBuilder message = new StringBuilder("More than one ");
        message.append(instanceField ? "instance" : "static").append(" field ");
        message.append(forAssignment ? "to which a value of " : "from which a value of ");
        message.append(desiredFieldType);
        message.append(forAssignment ? " can be assigned" : " can be read");
        message.append(" exists in ").append(secondField.getDeclaringClass()).append(": ");
        message.append(firstField.getName()).append(", ").append(secondField.getName());
        return message.toString();
    }

    private static boolean isCompatibleFieldType(Type fieldType, Type desiredType, boolean forAssignment) {
        Class<?> fieldClass = Utilities.getClassType(fieldType);
        Class<?> desiredClass = Utilities.getClassType(desiredType);
        if (Utilities.isSameTypeIgnoringAutoBoxing(desiredClass, fieldClass)) {
            return true;
        }
        if (forAssignment) {
            return fieldClass.isAssignableFrom(desiredClass);
        }
        return desiredClass.isAssignableFrom(fieldClass) || fieldClass.isAssignableFrom(desiredClass);
    }

    public static Class<?> getClassType(Type declaredType) {
        if (declaredType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)declaredType).getRawType();
        }
        return (Class)declaredType;
    }

    public static Object getFieldValue(Field field, Object targetObject) {
        Utilities.ensureThatMemberIsAccessible(field);
        try {
            return field.get(targetObject);
        }
        catch (IllegalAccessException e) {
            assert (false) : "Not expected to happen because the field was made accessible";
            throw new RuntimeException(e);
        }
    }

    public static Field setField(Class<?> theClass, Object targetObject, String fieldName, Object fieldValue) {
        Field field = fieldName == null ? Utilities.getDeclaredField(theClass, fieldValue.getClass(), targetObject != null, true) : Utilities.getDeclaredField(theClass, fieldName);
        Utilities.setFieldValue(field, targetObject, fieldValue);
        return field;
    }

    public static void setFieldValue(Field field, Object targetObject, Object value) {
        Utilities.ensureThatMemberIsAccessible(field);
        try {
            field.set(targetObject, value);
        }
        catch (IllegalAccessException e) {
            assert (false) : "Not expected to happen because the field was made accessible";
            throw new RuntimeException(e);
        }
    }

    public static Class<?>[] getParameterTypes(String mockDesc) {
        mockit.external.asm.Type[] paramTypes = mockit.external.asm.Type.getArgumentTypes(mockDesc);
        if (paramTypes.length == 0) {
            return NO_PARAMETERS;
        }
        Class[] paramClasses = new Class[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramClasses[i] = Utilities.getClassForType(paramTypes[i]);
        }
        return paramClasses;
    }

    public static Class<?> getClassForType(mockit.external.asm.Type type) {
        int elementSort = type.getSort();
        if (elementSort < PRIMITIVE_TYPES.length) {
            return PRIMITIVE_TYPES[elementSort];
        }
        String className = elementSort == 9 ? type.getDescriptor().replace('/', '.') : type.getClassName();
        return Utilities.loadClass(className);
    }

    public static void filterStackTrace(Throwable t) {
        StackTraceElement[] originalST = t.getStackTrace();
        ArrayList<StackTraceElement> filteredST = new ArrayList<StackTraceElement>(originalST.length);
        for (StackTraceElement ste : originalST) {
            String where;
            if (ste.getFileName() == null || (where = ste.getClassName()).startsWith("sun.") && !ste.isNativeMethod() || where.startsWith("org.junit.") || where.startsWith("junit.") || where.startsWith("org.testng.") || where.startsWith("mockit.") && !ste.getFileName().endsWith("Test.java")) continue;
            filteredST.add(ste);
        }
        t.setStackTrace(filteredST.toArray(new StackTraceElement[filteredST.size()]));
        Throwable cause = t.getCause();
        if (cause != null) {
            Utilities.filterStackTrace(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void throwCheckedException(Exception exceptionToThrow) {
        Class<ThrowOfCheckedException> clazz = ThrowOfCheckedException.class;
        synchronized (ThrowOfCheckedException.class) {
            ThrowOfCheckedException.exceptionToThrow = exceptionToThrow;
            Utilities.newInstanceUsingDefaultConstructor(ThrowOfCheckedException.class);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Object newInstanceUsingDefaultConstructor(Class<?> aClass) {
        try {
            return aClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie);
        }
        catch (IllegalAccessException ignore) {
            return Utilities.newInstance(aClass);
        }
    }

    public static boolean isAnonymousClass(Class<?> aClass) {
        String className = aClass.getName();
        int p = className.lastIndexOf(36);
        return Utilities.hasPositiveDigit(className, p);
    }

    public static boolean hasPositiveDigit(String className, int positionJustBefore) {
        int nextPos;
        if (positionJustBefore > 0 && (nextPos = positionJustBefore + 1) < className.length()) {
            char c = className.charAt(nextPos);
            return c >= '1' && c <= '9';
        }
        return false;
    }

    public static String objectIdentity(Object obj) {
        return obj.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(obj));
    }

    public static <A extends Annotation> A getAnnotation(Annotation[] annotations, Class<A> annotation) {
        for (Annotation paramAnnotation : annotations) {
            if (paramAnnotation.annotationType() != annotation) continue;
            return (A)paramAnnotation;
        }
        return null;
    }

    private static final class ThrowOfCheckedException {
        static Exception exceptionToThrow;

        ThrowOfCheckedException() throws Exception {
            throw exceptionToThrow;
        }
    }
}

