/*
 * Decompiled with CFR 0.152.
 */
package ext.jtester.hamcrest.collection;

import ext.jtester.hamcrest.Factory;
import ext.jtester.hamcrest.FeatureMatcher;
import ext.jtester.hamcrest.Matcher;
import ext.jtester.hamcrest.core.DescribedAs;
import ext.jtester.hamcrest.core.IsEqual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsArrayWithSize<E>
extends FeatureMatcher<E[], Integer> {
    public IsArrayWithSize(Matcher<? super Integer> sizeMatcher) {
        super(sizeMatcher, "an array with size", "array size");
    }

    @Override
    protected Integer featureValueOf(E[] actual) {
        return actual.length;
    }

    @Factory
    public static <E> Matcher<E[]> arrayWithSize(Matcher<? super Integer> sizeMatcher) {
        return new IsArrayWithSize<E>(sizeMatcher);
    }

    @Factory
    public static <E> Matcher<E[]> arrayWithSize(int size) {
        return IsArrayWithSize.arrayWithSize(IsEqual.equalTo(size));
    }

    @Factory
    public static <E> Matcher<E[]> emptyArray() {
        Matcher<E[]> isEmpty = IsArrayWithSize.arrayWithSize(0);
        return DescribedAs.describedAs("an empty array", isEmpty, new Object[0]);
    }
}

