/*
 * Decompiled with CFR 0.152.
 */
package ext.jtester.hamcrest.collection;

import ext.jtester.hamcrest.Description;
import ext.jtester.hamcrest.Factory;
import ext.jtester.hamcrest.Matcher;
import ext.jtester.hamcrest.TypeSafeDiagnosingMatcher;
import ext.jtester.hamcrest.core.IsEqual;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsIterableContainingInAnyOrder<T>
extends TypeSafeDiagnosingMatcher<Iterable<? extends T>> {
    private final Collection<Matcher<? super T>> matchers;

    public IsIterableContainingInAnyOrder(Collection<Matcher<? super T>> matchers) {
        this.matchers = matchers;
    }

    @Override
    protected boolean matchesSafely(Iterable<? extends T> items, Description mismatchDescription) {
        Matching<T> matching = new Matching<T>(this.matchers, mismatchDescription);
        for (T item : items) {
            if (matching.matches(item)) continue;
            return false;
        }
        return matching.isFinished(items);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("iterable over ").appendList("[", ", ", "]", this.matchers).appendText(" in any order");
    }

    @Factory
    public static <E> Matcher<Iterable<? extends E>> containsInAnyOrder(Matcher<? super E> item) {
        return IsIterableContainingInAnyOrder.containsInAnyOrder(new ArrayList(Arrays.asList(item)));
    }

    @Factory
    public static <T> Matcher<Iterable<? extends T>> containsInAnyOrder(Matcher<? super T> ... matchers) {
        return IsIterableContainingInAnyOrder.containsInAnyOrder(Arrays.asList(matchers));
    }

    @Factory
    public static <T> Matcher<Iterable<? extends T>> containsInAnyOrder(T ... items) {
        ArrayList<Matcher<T>> matchers = new ArrayList<Matcher<T>>();
        for (T item : items) {
            matchers.add(IsEqual.equalTo(item));
        }
        return new IsIterableContainingInAnyOrder<T>(matchers);
    }

    @Factory
    public static <T> Matcher<Iterable<? extends T>> containsInAnyOrder(Collection<Matcher<? super T>> matchers) {
        return new IsIterableContainingInAnyOrder<T>(matchers);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Matching<S> {
        private final Collection<Matcher<? super S>> matchers;
        private final Description mismatchDescription;

        public Matching(Collection<Matcher<? super S>> matchers, Description mismatchDescription) {
            this.matchers = new ArrayList<Matcher<S>>(matchers);
            this.mismatchDescription = mismatchDescription;
        }

        public boolean matches(S item) {
            return this.isNotSurplus(item) && this.isMatched(item);
        }

        public boolean isFinished(Iterable<? extends S> items) {
            if (this.matchers.isEmpty()) {
                return true;
            }
            this.mismatchDescription.appendText("No item matches: ").appendList("", ", ", "", this.matchers).appendText(" in ").appendValueList("[", ", ", "]", items);
            return false;
        }

        private boolean isNotSurplus(S item) {
            if (this.matchers.isEmpty()) {
                this.mismatchDescription.appendText("Not matched: ").appendValue(item);
                return false;
            }
            return true;
        }

        private boolean isMatched(S item) {
            for (Matcher<S> matcher : this.matchers) {
                if (!matcher.matches(item)) continue;
                this.matchers.remove(matcher);
                return true;
            }
            this.mismatchDescription.appendText("Not matched: ").appendValue(item);
            return false;
        }
    }
}

