/*
 * Decompiled with CFR 0.152.
 */
package ext.jtester.hamcrest.collection;

import ext.jtester.hamcrest.Factory;
import ext.jtester.hamcrest.FeatureMatcher;
import ext.jtester.hamcrest.Matcher;
import ext.jtester.hamcrest.core.IsEqual;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsIterableWithSize<E>
extends FeatureMatcher<Iterable<E>, Integer> {
    public IsIterableWithSize(Matcher<? super Integer> sizeMatcher) {
        super(sizeMatcher, "an iterable with size", "iterable size");
    }

    @Override
    protected Integer featureValueOf(Iterable<E> actual) {
        int size = 0;
        Iterator<E> iterator = actual.iterator();
        while (iterator.hasNext()) {
            ++size;
            iterator.next();
        }
        return size;
    }

    @Factory
    public static <E> Matcher<Iterable<E>> iterableWithSize(Matcher<? super Integer> sizeMatcher) {
        return new IsIterableWithSize<E>(sizeMatcher);
    }

    @Factory
    public static <E> Matcher<Iterable<E>> iterableWithSize(int size) {
        return IsIterableWithSize.iterableWithSize(IsEqual.equalTo(size));
    }
}

