/*
 * Decompiled with CFR 0.152.
 */
package ext.jtester.hamcrest.core;

import ext.jtester.hamcrest.Description;
import ext.jtester.hamcrest.DiagnosingMatcher;
import ext.jtester.hamcrest.Factory;
import ext.jtester.hamcrest.Matcher;
import ext.jtester.hamcrest.core.IsNot;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllOf<T>
extends DiagnosingMatcher<T> {
    private final Iterable<Matcher> matchers;

    public AllOf(Iterable<Matcher> matchers) {
        this.matchers = matchers;
    }

    @Override
    public boolean matches(Object o, Description mismatchDescription) {
        for (Matcher matcher : this.matchers) {
            if (matcher.matches(o)) continue;
            mismatchDescription.appendDescriptionOf(matcher).appendText(" ");
            matcher.describeMismatch(o, mismatchDescription);
            return false;
        }
        return true;
    }

    @Override
    public void describeTo(Description description) {
        description.appendList("(", " and ", ")", this.matchers);
    }

    @Factory
    public static <T> Matcher<T> allOf(Iterable<Matcher> matchers) {
        return new AllOf<T>(matchers);
    }

    @Factory
    public static <T> Matcher<T> allOf(Matcher ... matchers) {
        return AllOf.allOf(Arrays.asList(matchers));
    }

    @Factory
    public static <T> Matcher<T> notAll(Iterable<Matcher> matchers) {
        Matcher<Matcher<T>> matcher = IsNot.not(AllOf.allOf(matchers));
        return matcher;
    }
}

