/*
 * Decompiled with CFR 0.152.
 */
package ext.jtester.objenesis.instantiator.basic;

import ext.jtester.objenesis.ObjenesisException;
import ext.jtester.objenesis.instantiator.ObjectInstantiator;
import java.io.ObjectStreamClass;
import java.lang.reflect.Method;

public class ObjectStreamClassInstantiator
implements ObjectInstantiator {
    private static Method newInstanceMethod;
    private final ObjectStreamClass objStreamClass;

    private static void initialize() {
        if (newInstanceMethod == null) {
            try {
                newInstanceMethod = ObjectStreamClass.class.getDeclaredMethod("newInstance", new Class[0]);
                newInstanceMethod.setAccessible(true);
            }
            catch (RuntimeException e) {
                throw new ObjenesisException(e);
            }
            catch (NoSuchMethodException e) {
                throw new ObjenesisException(e);
            }
        }
    }

    public ObjectStreamClassInstantiator(Class type) {
        ObjectStreamClassInstantiator.initialize();
        this.objStreamClass = ObjectStreamClass.lookup(type);
    }

    public Object newInstance() {
        try {
            return newInstanceMethod.invoke((Object)this.objStreamClass, new Object[0]);
        }
        catch (Exception e) {
            throw new ObjenesisException(e);
        }
    }
}

