/*
 * Decompiled with CFR 0.152.
 */
package ext.jtester.objenesis.instantiator.jrockit;

import ext.jtester.objenesis.ObjenesisException;
import ext.jtester.objenesis.instantiator.ObjectInstantiator;
import java.lang.reflect.Method;

public class JRockitLegacyInstantiator
implements ObjectInstantiator {
    private static Method safeAllocObjectMethod = null;
    private final Class type;

    private static void initialize() {
        if (safeAllocObjectMethod == null) {
            try {
                Class<?> memSystem = Class.forName("jrockit.vm.MemSystem");
                safeAllocObjectMethod = memSystem.getDeclaredMethod("safeAllocObject", Class.class);
                safeAllocObjectMethod.setAccessible(true);
            }
            catch (RuntimeException e) {
                throw new ObjenesisException(e);
            }
            catch (ClassNotFoundException e) {
                throw new ObjenesisException(e);
            }
            catch (NoSuchMethodException e) {
                throw new ObjenesisException(e);
            }
        }
    }

    public JRockitLegacyInstantiator(Class type) {
        JRockitLegacyInstantiator.initialize();
        this.type = type;
    }

    public Object newInstance() {
        try {
            return safeAllocObjectMethod.invoke(null, this.type);
        }
        catch (Exception e) {
            throw new ObjenesisException(e);
        }
    }
}

