/*
 * Decompiled with CFR 0.152.
 */
package ext.jtester.objenesis.strategy;

import ext.jtester.objenesis.ObjenesisException;
import ext.jtester.objenesis.instantiator.ObjectInstantiator;
import ext.jtester.objenesis.instantiator.basic.ObjectStreamClassInstantiator;
import ext.jtester.objenesis.instantiator.gcj.GCJSerializationInstantiator;
import ext.jtester.objenesis.instantiator.perc.PercSerializationInstantiator;
import ext.jtester.objenesis.instantiator.sun.Sun13SerializationInstantiator;
import ext.jtester.objenesis.strategy.BaseInstantiatorStrategy;
import java.io.NotSerializableException;
import java.io.Serializable;

public class SerializingInstantiatorStrategy
extends BaseInstantiatorStrategy {
    public ObjectInstantiator newInstantiatorOf(Class type) {
        if (!Serializable.class.isAssignableFrom(type)) {
            throw new ObjenesisException(new NotSerializableException(type + " not serializable"));
        }
        if (JVM_NAME.startsWith("Java HotSpot")) {
            if (VM_VERSION.startsWith("1.3")) {
                return new Sun13SerializationInstantiator(type);
            }
        } else {
            if (JVM_NAME.startsWith("GNU libgcj")) {
                return new GCJSerializationInstantiator(type);
            }
            if (JVM_NAME.startsWith("PERC")) {
                return new PercSerializationInstantiator(type);
            }
        }
        return new ObjectStreamClassInstantiator(type);
    }
}

