/*
 * Decompiled with CFR 0.152.
 */
package ext.jtester.org.apache.commons.collections;

import ext.jtester.org.apache.commons.collections.Transformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class CollectionUtils {
    public static Collection union(Collection a, Collection b) {
        ArrayList list = new ArrayList();
        Map mapa = CollectionUtils.getCardinalityMap(a);
        Map mapb = CollectionUtils.getCardinalityMap(b);
        HashSet elts = new HashSet(a);
        elts.addAll(b);
        for (Object obj : elts) {
            int m = Math.max(CollectionUtils.getFreq(obj, mapa), CollectionUtils.getFreq(obj, mapb));
            for (int i = 0; i < m; ++i) {
                list.add(obj);
            }
        }
        return list;
    }

    public static Collection intersection(Collection a, Collection b) {
        ArrayList list = new ArrayList();
        Map mapa = CollectionUtils.getCardinalityMap(a);
        Map mapb = CollectionUtils.getCardinalityMap(b);
        HashSet elts = new HashSet(a);
        elts.addAll(b);
        for (Object obj : elts) {
            int m = Math.min(CollectionUtils.getFreq(obj, mapa), CollectionUtils.getFreq(obj, mapb));
            for (int i = 0; i < m; ++i) {
                list.add(obj);
            }
        }
        return list;
    }

    public static Collection disjunction(Collection a, Collection b) {
        ArrayList list = new ArrayList();
        Map mapa = CollectionUtils.getCardinalityMap(a);
        Map mapb = CollectionUtils.getCardinalityMap(b);
        HashSet elts = new HashSet(a);
        elts.addAll(b);
        for (Object obj : elts) {
            int m = Math.max(CollectionUtils.getFreq(obj, mapa), CollectionUtils.getFreq(obj, mapb)) - Math.min(CollectionUtils.getFreq(obj, mapa), CollectionUtils.getFreq(obj, mapb));
            for (int i = 0; i < m; ++i) {
                list.add(obj);
            }
        }
        return list;
    }

    public static Collection subtract(Collection a, Collection b) {
        ArrayList list = new ArrayList(a);
        Iterator it = b.iterator();
        while (it.hasNext()) {
            list.remove(it.next());
        }
        return list;
    }

    public static boolean containsAny(Collection a, Collection b) {
        Iterator iter = a.iterator();
        while (iter.hasNext()) {
            if (!b.contains(iter.next())) continue;
            return true;
        }
        return false;
    }

    public static Map getCardinalityMap(Collection col) {
        HashMap count = new HashMap();
        for (Object obj : col) {
            Integer c = (Integer)count.get(obj);
            if (null == c) {
                count.put(obj, new Integer(1));
                continue;
            }
            count.put(obj, new Integer(c + 1));
        }
        return count;
    }

    public static boolean isSubCollection(Collection a, Collection b) {
        Map mapa = CollectionUtils.getCardinalityMap(a);
        Map mapb = CollectionUtils.getCardinalityMap(b);
        for (Object obj : a) {
            if (CollectionUtils.getFreq(obj, mapa) <= CollectionUtils.getFreq(obj, mapb)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualCollection(Collection a, Collection b) {
        if (a.size() != b.size()) {
            return false;
        }
        Map mapa = CollectionUtils.getCardinalityMap(a);
        Map mapb = CollectionUtils.getCardinalityMap(b);
        if (mapa.size() != mapb.size()) {
            return false;
        }
        for (Object obj : mapa.keySet()) {
            if (CollectionUtils.getFreq(obj, mapa) == CollectionUtils.getFreq(obj, mapb)) continue;
            return false;
        }
        return true;
    }

    public static int cardinality(Object obj, Collection col) {
        int count = 0;
        for (Object elt : col) {
            if ((null != obj || null != elt) && !obj.equals(elt)) continue;
            ++count;
        }
        return count;
    }

    public static void transform(Collection collection, Transformer transformer) {
        if (collection != null && transformer != null) {
            if (collection instanceof List) {
                List list = (List)collection;
                ListIterator<Object> iter = list.listIterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    iter.set(transformer.transform(element));
                }
            } else {
                Collection resultCollection = CollectionUtils.collect(collection, transformer);
                collection.clear();
                collection.addAll(resultCollection);
            }
        }
    }

    public static Collection collect(Collection inputCollection, Transformer transformer) {
        ArrayList answer = new ArrayList(inputCollection.size());
        CollectionUtils.collect(inputCollection, transformer, answer);
        return answer;
    }

    public static Collection collect(Iterator inputIterator, Transformer transformer) {
        ArrayList answer = new ArrayList();
        CollectionUtils.collect(inputIterator, transformer, answer);
        return answer;
    }

    public static Collection collect(Collection inputCollection, Transformer transformer, Collection outputCollection) {
        if (inputCollection != null) {
            return CollectionUtils.collect(inputCollection.iterator(), transformer, outputCollection);
        }
        return outputCollection;
    }

    public static Collection collect(Iterator inputIterator, Transformer transformer, Collection outputCollection) {
        if (inputIterator != null && transformer != null) {
            while (inputIterator.hasNext()) {
                Object item = inputIterator.next();
                Object value = transformer.transform(item);
                outputCollection.add(value);
            }
        }
        return outputCollection;
    }

    public static void addAll(Collection collection, Iterator iterator) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
    }

    public static void addAll(Collection collection, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            collection.add(enumeration.nextElement());
        }
    }

    public static void addAll(Collection collection, Object[] elements) {
        int size = elements.length;
        for (int i = 0; i < size; ++i) {
            collection.add(elements[i]);
        }
    }

    public static Object index(Object obj, int idx) {
        return CollectionUtils.index(obj, new Integer(idx));
    }

    public static Object index(Object obj, Object index) {
        Map map;
        if (obj instanceof Map && (map = (Map)obj).containsKey(index)) {
            return map.get(index);
        }
        int idx = -1;
        if (index instanceof Integer) {
            idx = (Integer)index;
        }
        if (idx < 0) {
            return obj;
        }
        if (obj instanceof Map) {
            Map map2 = (Map)obj;
            Iterator iterator = map2.keySet().iterator();
            return CollectionUtils.index(iterator, idx);
        }
        if (obj instanceof List) {
            return ((List)obj).get(idx);
        }
        if (obj instanceof Object[]) {
            return ((Object[])obj)[idx];
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            while (enumeration.hasMoreElements()) {
                if (--idx == -1) {
                    return enumeration.nextElement();
                }
                enumeration.nextElement();
            }
        } else {
            if (obj instanceof Iterator) {
                return CollectionUtils.index((Iterator)obj, idx);
            }
            if (obj instanceof Collection) {
                Iterator iterator = ((Collection)obj).iterator();
                return CollectionUtils.index(iterator, idx);
            }
        }
        return obj;
    }

    private static Object index(Iterator iterator, int idx) {
        while (iterator.hasNext()) {
            if (--idx == -1) {
                return iterator.next();
            }
            iterator.next();
        }
        return iterator;
    }

    public static void reverseArray(Object[] array) {
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            Object tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    private static final int getFreq(Object obj, Map freqMap) {
        try {
            return (Integer)freqMap.get(obj);
        }
        catch (NullPointerException e) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return 0;
    }

    static class UnmodifiableIterator
    implements Iterator {
        protected final Iterator iterator;

        public UnmodifiableIterator(Iterator iterator) {
            if (iterator == null) {
                throw new IllegalArgumentException("Iterator must not be null");
            }
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class SynchronizedCollection {
        protected final Collection collection;

        public SynchronizedCollection(Collection collection) {
            if (collection == null) {
                throw new IllegalArgumentException("Collection must not be null");
            }
            this.collection = collection;
        }

        public synchronized int size() {
            return this.collection.size();
        }

        public synchronized boolean isEmpty() {
            return this.collection.isEmpty();
        }

        public synchronized boolean contains(Object o) {
            return this.collection.contains(o);
        }

        public Iterator iterator() {
            return this.collection.iterator();
        }

        public synchronized Object[] toArray() {
            return this.collection.toArray();
        }

        public synchronized Object[] toArray(Object[] o) {
            return this.collection.toArray(o);
        }

        public synchronized boolean add(Object o) {
            return this.collection.add(o);
        }

        public synchronized boolean remove(Object o) {
            return this.collection.remove(o);
        }

        public synchronized boolean containsAll(Collection c2) {
            return this.collection.containsAll(c2);
        }

        public synchronized boolean addAll(Collection c2) {
            return this.collection.addAll(c2);
        }

        public synchronized boolean removeAll(Collection c2) {
            return this.collection.removeAll(c2);
        }

        public synchronized boolean retainAll(Collection c2) {
            return this.collection.retainAll(c2);
        }

        public synchronized void clear() {
            this.collection.clear();
        }

        public synchronized boolean equals(Object o) {
            return ((Object)this.collection).equals(o);
        }

        public synchronized int hashCode() {
            return ((Object)this.collection).hashCode();
        }

        public synchronized String toString() {
            return this.collection.toString();
        }
    }

    static class UnmodifiableCollection
    extends CollectionWrapper {
        public UnmodifiableCollection(Collection c) {
            super(c);
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return new UnmodifiableIterator(this.collection.iterator());
        }
    }

    static class CollectionWrapper
    implements Collection {
        protected final Collection collection;

        public CollectionWrapper(Collection collection) {
            if (collection == null) {
                throw new IllegalArgumentException("Collection must not be null");
            }
            this.collection = collection;
        }

        public int size() {
            return this.collection.size();
        }

        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        public boolean contains(Object o) {
            return this.collection.contains(o);
        }

        public Iterator iterator() {
            return this.collection.iterator();
        }

        public Object[] toArray() {
            return this.collection.toArray();
        }

        public Object[] toArray(Object[] o) {
            return this.collection.toArray(o);
        }

        public boolean add(Object o) {
            return this.collection.add(o);
        }

        public boolean remove(Object o) {
            return this.collection.remove(o);
        }

        public boolean containsAll(Collection c2) {
            return this.collection.containsAll(c2);
        }

        public boolean addAll(Collection c2) {
            return this.collection.addAll(c2);
        }

        public boolean removeAll(Collection c2) {
            return this.collection.removeAll(c2);
        }

        public boolean retainAll(Collection c2) {
            return this.collection.retainAll(c2);
        }

        public void clear() {
            this.collection.clear();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return ((Object)this.collection).equals(o);
        }

        public int hashCode() {
            return ((Object)this.collection).hashCode();
        }

        public String toString() {
            return this.collection.toString();
        }
    }
}

