/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface SpringBeanRemote {
    public String value() default "";

    public String serviceUrl() default "";

    public Class serviceInterface() default Object.class;

    public SpringBeanRemoteType type() default SpringBeanRemoteType.hessian;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpringBeanRemoteType {
        hessian,
        httpinvoker;


        public static final SpringBeanRemoteType getTypeFromURL(String url) {
            if (url == null || !url.contains("/")) {
                return null;
            }
            if (url.startsWith(hessian.name() + "/")) {
                return hessian;
            }
            if (url.startsWith(httpinvoker.name() + "/")) {
                return httpinvoker;
            }
            return null;
        }
    }
}

