/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.jtester.utility.JsonHelper;
import org.jtester.utility.StringHelper;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.TYPE, ElementType.CONSTRUCTOR})
public @interface Tracer {
    public boolean spring() default true;

    public boolean jdbc() default true;

    public Info info() default Info.TOJSON;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Info {
        TOSTRING{

            public String toInfoString(Object o) {
                return o == null ? "<null>" : o.toString();
            }
        }
        ,
        TOJSON{

            public String toInfoString(Object o) {
                if (o == null) {
                    return "<null>";
                }
                try {
                    return JsonHelper.toJSON(o);
                }
                catch (Throwable e) {
                    return "to json error:" + StringHelper.exceptionTrace(e);
                }
            }
        };


        public abstract String toInfoString(Object var1);
    }
}

