/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.bytecode.imposteriser.invokabel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jtester.bytecode.imposteriser.Invocation;
import org.jtester.bytecode.imposteriser.Invokable;
import org.jtester.bytecode.reflector.FieldAccessor;
import org.jtester.core.TestedObject;

public class FieldProxy
implements Invokable {
    private final String fieldName;
    private final FieldAccessor accessor;
    private final Class testClazz;

    public FieldProxy(Class testClazz, String fieldName) {
        this.fieldName = fieldName;
        this.accessor = new FieldAccessor(testClazz, fieldName);
        this.testClazz = testClazz;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object test = TestedObject.currTestedObject();
        Object fieldValue = this.accessor.get(test);
        if (fieldValue == null) {
            throw new NullPointerException(String.format("field[%s] value of object[%s] is null.", this.fieldName, this.testClazz.getName()));
        }
        try {
            Method method = invocation.getInvokedMethod();
            Object[] paras = invocation.getParametersAsArray();
            boolean accessible = method.isAccessible();
            if (!accessible) {
                method.setAccessible(true);
            }
            Object o = method.invoke(fieldValue, paras);
            if (!accessible) {
                method.setAccessible(false);
            }
            return o;
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                throw ((InvocationTargetException)e).getTargetException();
            }
            throw e;
        }
    }
}

