/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.bytecode.reflector;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jtester.bytecode.reflector.helper.FieldHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldAccessor<T> {
    private final Field field;
    private final String clazName;
    private final String fieldName;

    public FieldAccessor(Class claz, String fieldName) {
        if (fieldName == null || claz == null) {
            throw new NullPointerException("to get a field, the class type or field name can't be null.");
        }
        this.field = FieldHelper.getField(claz, fieldName);
        this.clazName = claz.getName();
        this.fieldName = fieldName;
    }

    public FieldAccessor(Object target, String fieldName) {
        if (fieldName == null || target == null) {
            throw new NullPointerException("to get a field, the target or field name can't be null.");
        }
        Class<?> claz = target.getClass();
        this.field = FieldHelper.getField(claz, fieldName);
        this.clazName = claz.getName();
        this.fieldName = fieldName;
    }

    public FieldAccessor(Class claz, Field field) {
        if (field == null || claz == null) {
            throw new NullPointerException("to get a field, the target or field name can't be null.");
        }
        this.field = field;
        this.clazName = claz.getName();
        this.fieldName = field.getName();
    }

    public Class getFieldType() {
        return this.field.getType();
    }

    public final T get(Object target) {
        boolean isAccessible = this.field.isAccessible();
        try {
            this.field.setAccessible(true);
            Object object = this.field.get(target);
            return (T)object;
        }
        catch (Exception e) {
            String info = String.format("to get field[%s] value from class[%s] error.", this.fieldName, this.clazName);
            throw new RuntimeException(info, e);
        }
        finally {
            this.field.setAccessible(isAccessible);
        }
    }

    public final T getStatic() {
        if (!Modifier.isStatic(this.field.getModifiers())) {
            throw new IllegalArgumentException("Field " + this.fieldName + " is not static");
        }
        return this.get(null);
    }

    public final void set(Object target, Object value) {
        boolean isAccessible = this.field.isAccessible();
        try {
            this.field.setAccessible(true);
            this.field.set(target, value);
        }
        catch (Exception e) {
            String info = String.format("to set field[%s] value into target[%s] error.", this.fieldName, this.clazName);
            throw new RuntimeException(info, e);
        }
        finally {
            this.field.setAccessible(isAccessible);
        }
    }

    public final void setStatic(Object value) {
        if (!Modifier.isStatic(this.field.getModifiers())) {
            throw new IllegalArgumentException("Field " + this.fieldName + " is not static");
        }
        this.set(null, value);
    }
}

