/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.bytecode.reflector;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.bytecode.reflector.helper.MethodHelper;
import org.jtester.exception.ExceptionWrapper;
import org.jtester.exception.JTesterException;
import org.jtester.exception.NoSuchMethodRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodAccessor<T> {
    private final Method method;
    private final Class targetClaz;

    public MethodAccessor(Class targetClaz, String methodName, Class ... parametersType) {
        this.targetClaz = targetClaz;
        this.method = MethodHelper.getMethod(targetClaz, methodName, parametersType);
    }

    public MethodAccessor(Object target, String methodName, Class ... parametersType) {
        this.targetClaz = target.getClass();
        this.method = MethodHelper.getMethod(this.targetClaz, methodName, parametersType);
    }

    public MethodAccessor(Method method) {
        this.method = method;
        this.targetClaz = method.getDeclaringClass();
    }

    public Method getMethod() {
        return this.method;
    }

    public T invoke(Object target, Object[] args) throws Exception {
        boolean isAccessible = this.method.isAccessible();
        try {
            Object object = this.method.invoke(target, args);
            return (T)object;
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof Exception) {
                throw (Exception)te;
            }
            throw e;
        }
        finally {
            this.method.setAccessible(isAccessible);
        }
    }

    public T invokeUnThrow(Object target, Object[] args) {
        try {
            return this.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw ExceptionWrapper.wrapWithRuntimeException(targetException);
        }
        catch (Throwable e) {
            throw ExceptionWrapper.wrapWithRuntimeException(e);
        }
    }

    public T invokeStatic(Object[] args) throws Exception {
        if (!Modifier.isStatic(this.method.getModifiers())) {
            String methodDesc = this.method.getName() + "(" + Arrays.toString(this.method.getParameterTypes()) + ")";
            throw new NoSuchMethodRuntimeException("No such static method: " + methodDesc + " in class[" + this.targetClaz + "]");
        }
        return this.invoke(null, args);
    }

    public T invokeStaticUnThrow(Object[] args) {
        try {
            return this.invokeStatic(args);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw ExceptionWrapper.wrapWithRuntimeException(targetException);
        }
        catch (Throwable e) {
            throw ExceptionWrapper.wrapWithRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T invokeMethod(Object target, Method method, Object ... arguments) throws Exception {
        boolean isAccessible = method.isAccessible();
        try {
            method.setAccessible(true);
            Object object = method.invoke(target, arguments);
            return (T)object;
        }
        finally {
            method.setAccessible(isAccessible);
        }
    }

    public static <T> T invokeMethodUnThrow(Object target, Method method, Object ... arguments) {
        if (method == null) {
            throw new RuntimeException("reflector invoke ,the argument[method] can't be null.");
        }
        try {
            return MethodAccessor.invokeMethod(target, method, arguments);
        }
        catch (Exception e) {
            throw new JTesterException("Unable to invoke method[" + method.getName() + "].", e);
        }
    }

    public static <T> T invokeMethod(Object target, String methodNmae, Object ... paras) throws Exception {
        if (target == null) {
            throw new RuntimeException("the target object can't be null!");
        }
        Object _target = ClazzHelper.getProxiedObject(target);
        Class[] paraClazes = MethodHelper.getParameterClazz(paras);
        Method method = MethodHelper.getMethod(_target.getClass(), methodNmae, paraClazes);
        T result = MethodAccessor.invokeMethod(_target, method, paras);
        return result;
    }

    public static <T> T invokeMethodUnThrow(Object target, String methodName, Object ... paras) {
        try {
            return MethodAccessor.invokeMethod(target, methodName, paras);
        }
        catch (Exception e) {
            throw new JTesterException("Unable to invoke method[" + methodName + "].", e);
        }
    }
}

