/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.bytecode.reflector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jtester.bytecode.reflector.MethodAccessor;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.bytecode.reflector.helper.FieldHelper;
import org.jtester.exception.NoSuchFieldRuntimeException;
import org.jtester.utility.ArrayHelper;
import org.jtester.utility.ListHelper;
import org.jtester.utility.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAccessor {
    public static Object getPropertyByOgnl(Object target, String ognl) {
        Object o = PropertyAccessor.getPropertyByOgnl(target, ognl, true);
        return o;
    }

    public static Object getPropertyByOgnl(Object object, String ognl, boolean throwNoProperty) {
        String[] expressions = ognl.split("\\.");
        try {
            Object target = object;
            for (String prop : expressions) {
                if (target == null && !throwNoProperty) {
                    return null;
                }
                target = PropertyAccessor.getProperty(target, prop);
            }
            return target;
        }
        catch (NoSuchFieldRuntimeException e) {
            if (throwNoProperty) {
                String clazname = object == null ? "null" : object.getClass().getName();
                throw new NoSuchFieldRuntimeException("can't find property[" + ognl + "] in object[" + clazname + "]", e);
            }
            return object;
        }
    }

    public static Object getProperty(Object o, String prop) {
        if (o == null) {
            throw new RuntimeException("can't get the property value from a null object.");
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            if (map.containsKey(prop)) {
                return map.get(prop);
            }
            throw new NoSuchFieldRuntimeException("no key[" + prop + "] value in map.");
        }
        Object target = ClazzHelper.getProxiedObject(o);
        try {
            String method = StringHelper.camel("get", prop);
            MethodAccessor accessor = new MethodAccessor(target, method, new Class[0]);
            return accessor.invoke(target, new Object[0]);
        }
        catch (Throwable e) {
            try {
                String method = StringHelper.camel("is", prop);
                MethodAccessor accessor = new MethodAccessor(target, method, new Class[0]);
                Object b = accessor.invoke(target, new Object[0]);
                if (b instanceof Boolean) {
                    return b;
                }
                throw new RuntimeException();
            }
            catch (Throwable e1) {
                Object o2 = FieldHelper.getFieldValue(target, prop);
                return o2;
            }
        }
    }

    public static Object[] getPropertyValue(Object object, String[] ognls, boolean throwException) {
        ArrayList<Object> os = new ArrayList<Object>();
        for (String ognl : ognls) {
            Object value = PropertyAccessor.getPropertyByOgnl(object, ognl, throwException);
            os.add(value);
        }
        return os.toArray(new Object[0]);
    }

    public static List<?> getArrayItemProperty(Object arr, String property) {
        List coll = ListHelper.toList(arr);
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object o : coll) {
            Object value = PropertyAccessor.getPropertyByOgnl(o, property, false);
            values.add(value);
        }
        return values;
    }

    public static Collection getArrayOrItemProperty(Object item, String property) {
        List values = null;
        if (ArrayHelper.isCollOrArray(item)) {
            values = PropertyAccessor.getArrayItemProperty(item, property);
        } else {
            Object o = PropertyAccessor.getProperty(item, property);
            values = ListHelper.toList(o);
        }
        return values;
    }

    public static Object[][] getArrayItemProperties(Object arr, String[] properties) {
        List coll = ListHelper.toList(arr);
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (Object o : coll) {
            Object[] props = PropertyAccessor.getPropertyValue(o, properties, false);
            values.add(props);
        }
        return (Object[][])values.toArray((T[])new Object[0][0]);
    }

    public static List<List> getPropertiesOfList(List list, String[] properties, boolean throwNoProperty) {
        ArrayList<List> result = new ArrayList<List>();
        for (Object target : list) {
            ArrayList<Object> items = new ArrayList<Object>();
            if (ArrayHelper.isCollOrArray(target) && !throwNoProperty) {
                List value = ListHelper.toList(target);
                result.add(value);
                continue;
            }
            for (String ognl : properties) {
                Object value = PropertyAccessor.getPropertyByOgnl(target, ognl, throwNoProperty);
                items.add(value);
            }
            result.add(items);
        }
        return result;
    }

    public static List<List> getPropertySetsOfList(List list, String[] properties, boolean throwNoProperty) {
        ArrayList<List> result = new ArrayList<List>();
        for (String ognl : properties) {
            ArrayList<Object> items = new ArrayList<Object>();
            for (Object target : list) {
                if (ArrayHelper.isCollOrArray(target)) {
                    List _target = ListHelper.toList(target);
                    List values = PropertyAccessor.getPropertyOfList(_target, ognl, throwNoProperty);
                    items.add(values);
                    continue;
                }
                Object value = PropertyAccessor.getPropertyByOgnl(target, ognl, throwNoProperty);
                items.add(value);
            }
            result.add(items);
        }
        return result;
    }

    public static List getPropertyOfList(List list, String ognl, boolean throwNoProperty) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object target : list) {
            Object value = PropertyAccessor.getPropertyByOgnl(target, ognl, throwNoProperty);
            result.add(value);
        }
        return result;
    }

    public static List getPropertiesOfPoJo(Object target, String[] properties, boolean throwNoProperty) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (String ognl : properties) {
            Object value = PropertyAccessor.getPropertyByOgnl(target, ognl, throwNoProperty);
            result.add(value);
        }
        return result;
    }
}

