/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.bytecode.reflector.helper;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jtester.exception.JTesterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClazzFinder {
    public static final String SUN_BOOT_PATH = "sun.boot.class.path";
    public static final String JAVA_EXT_DIRS = "java.ext.dirs";
    public static final String JAVA_CLASS_PATH = "java.class.path";

    protected static boolean isAppRunningInIde(String clazPath) {
        boolean in_ide = false;
        StringTokenizer tokenizer = new StringTokenizer(clazPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String entry = tokenizer.nextToken();
            if (entry.endsWith(".jar")) continue;
            in_ide = true;
            break;
        }
        return in_ide;
    }

    protected static boolean isAppRunningInJar(String clazPath) {
        boolean result = false;
        StringTokenizer tokenizer = new StringTokenizer(clazPath, File.pathSeparator);
        if (tokenizer.countTokens() == 1 && clazPath.endsWith(".jar")) {
            result = true;
        }
        return result;
    }

    protected static List<String> findClazzInIdeApp(String clazPath, String packPath) throws IOException {
        LinkedList<String> clazzes = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(clazPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String entry = tokenizer.nextToken();
            if (entry.endsWith(".jar")) {
                clazzes.addAll(ClazzFinder.findClazzInJarFile(new JarFile(entry), packPath));
                continue;
            }
            clazzes.addAll(ClazzFinder.findClazzInIdeTarget(entry, packPath));
        }
        return clazzes;
    }

    protected static List<String> findClazzInJarApp(String jarName, String packPath) throws IOException {
        LinkedList<String> clazzes = new LinkedList<String>();
        JarFile jarFile = new JarFile(jarName);
        clazzes.addAll(ClazzFinder.findClazzInJarFile(jarFile, packPath));
        Manifest manifest = jarFile.getManifest();
        if (manifest == null) {
            return clazzes;
        }
        String jarClassPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        StringTokenizer tokenizer = new StringTokenizer(jarClassPath, " ");
        while (tokenizer.hasMoreTokens()) {
            String jarFileName = tokenizer.nextToken();
            clazzes.addAll(ClazzFinder.findClazzInJarFile(new JarFile(jarFileName), packPath));
        }
        return clazzes;
    }

    protected static List<String> findClazzInIdeTarget(String target, String packPath) {
        LinkedList<String> clazzes = new LinkedList<String>();
        String dir = target + File.separator + packPath.replace('.', File.separatorChar);
        File directory = new File(dir);
        String[] classnames = directory.list();
        if (classnames == null) {
            return clazzes;
        }
        for (String clazname : classnames) {
            if (!clazname.endsWith(".class")) continue;
            String claz = packPath + "." + clazname.substring(0, clazname.indexOf(46));
            clazzes.add(claz);
        }
        return clazzes;
    }

    private static List<String> findClazzInJarFile(JarFile aJarFile, String packPath) {
        LinkedList<String> clazzes = new LinkedList<String>();
        Enumeration<JarEntry> jarEntries = aJarFile.entries();
        String pack = ClazzFinder.pathReplace(packPath);
        while (jarEntries.hasMoreElements()) {
            String clazName = jarEntries.nextElement().getName();
            int index = clazName.lastIndexOf(".class");
            if (index == -1 || index != clazName.length() - 6) continue;
            clazName = ClazzFinder.pathReplace(clazName.substring(0, index));
            index = clazName.lastIndexOf(".");
            String packName = "";
            if (index != -1) {
                packName = clazName.substring(0, index);
            }
            if (!packName.equals(pack)) continue;
            clazzes.add(clazName);
        }
        return clazzes;
    }

    protected static String pathReplace(String path) {
        return path.replace('/', '.').replace('\\', '.');
    }

    public static List<String> findClazz(String packPath) {
        String classPath = System.getProperty(JAVA_CLASS_PATH);
        boolean runInIDE = ClazzFinder.isAppRunningInIde(classPath);
        try {
            List<String> clazzes = null;
            clazzes = runInIDE ? ClazzFinder.findClazzInIdeApp(classPath, packPath) : ClazzFinder.findClazzInJarApp(classPath, packPath);
            return clazzes;
        }
        catch (Throwable e) {
            String error = String.format("RunInIDE : %s , classpath : %s", String.valueOf(runInIDE), classPath);
            throw new JTesterException(error, e);
        }
    }

    public static List<String> findClazz(Class claz) {
        String pack = "";
        Package _package = claz.getPackage();
        if (_package != null) {
            pack = _package.getName();
        }
        return ClazzFinder.findClazz(pack);
    }

    public static String finePackageDir(Class claz) {
        String pack = "";
        Package _package = claz.getPackage();
        if (_package != null) {
            pack = _package.getName();
        }
        return pack.replaceAll("\\.", "/");
    }
}

