/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.bytecode.reflector.helper;

import ext.jtester.objenesis.ObjenesisHelper;
import ext.jtester.org.apache.commons.io.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mockit.Mockit;
import org.jtester.bytecode.reflector.helper.FieldHelper;
import org.jtester.exception.JTesterException;
import org.jtester.module.core.helper.SpringModuleHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClazzHelper {
    private static final Map<String, Boolean> clazAvailableCache = new HashMap<String, Boolean>();
    public static final String VALID_PACK_REGULAR = "[^\\.]*";
    private static final String Proxy_Type_Pattern = ".*\\$[Pp]roxy\\d+.*";

    public static boolean isClassAvailable(String className) {
        Boolean isAvailable = clazAvailableCache.get(className);
        if (isAvailable != null) {
            return isAvailable;
        }
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
            clazAvailableCache.put(className, true);
            return true;
        }
        catch (ClassNotFoundException e) {
            clazAvailableCache.put(className, false);
            return false;
        }
    }

    public static <T> Class<T> getClazz(String className) {
        try {
            return Class.forName(className);
        }
        catch (Throwable t) {
            throw new JTesterException("Could not load class with name " + className, t);
        }
    }

    public static boolean classFileExistsInClasspath(String className) {
        String classFileName = className.replace('.', '/') + ".class";
        return ClazzHelper.class.getClassLoader().getResource(classFileName) != null;
    }

    public static final boolean doesImportSchemaExport() {
        try {
            Class.forName("org.hibernate.tool.hbm2ddl.SchemaExport");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static final String getPackFromClassName(String clazzName) {
        int index = clazzName.lastIndexOf(".");
        String pack = "";
        if (index > 0) {
            pack = clazzName.substring(0, index);
        }
        return pack;
    }

    public static final String getPathFromPath(String clazzName) {
        String pack = ClazzHelper.getPackFromClassName(clazzName);
        return pack.replace(".", "/");
    }

    public static final String getPathFromPath(Class clazz) {
        if (clazz == null) {
            return "";
        }
        return ClazzHelper.getPathFromPath(clazz.getName());
    }

    public static final void generateClazz(String clazzName, byte[] r) throws IOException {
        FileOutputStream file = new FileOutputStream("d:/" + clazzName.substring(clazzName.lastIndexOf(46) + 1) + ".class");
        file.write(r);
        file.flush();
        file.close();
    }

    public static String getPackageRegex(String regexPackage) {
        String _interfaceKey = regexPackage.replace('*', '#');
        String regex = _interfaceKey.replace(".", "\\.");
        regex = regex.replace("\\.##\\.", "(\\.|\\..*\\.)");
        regex = regex.replace("##\\.", ".*\\.");
        regex = regex.replace("#", VALID_PACK_REGULAR);
        return regex;
    }

    public static boolean isInterfaceOrAbstract(Class type) {
        if (type == null) {
            throw new RuntimeException("type can't be null.");
        }
        if (type.isInterface()) {
            return true;
        }
        return Modifier.isAbstract(type.getModifiers());
    }

    public static String exactBeanName(Method method) {
        String methodname = method.getName();
        if (methodname.equalsIgnoreCase("set") || !methodname.startsWith("set")) {
            return null;
        }
        String beanName = methodname.substring(3);
        beanName = beanName.substring(0, 1).toLowerCase() + beanName.substring(1);
        return beanName;
    }

    public static <T> T createInstanceOfType(String className) {
        try {
            Class<?> type = Class.forName(className);
            return (T)ClazzHelper.newInstance(type);
        }
        catch (ClassCastException e) {
            throw new JTesterException("Class " + className + " is not of expected type.", e);
        }
        catch (NoClassDefFoundError e) {
            throw new JTesterException("Unable to load class " + className, e);
        }
        catch (ClassNotFoundException e) {
            throw new JTesterException("Class " + className + " not found", e);
        }
        catch (JTesterException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JTesterException("Error while instantiating class " + className, e);
        }
    }

    public static boolean isAssignable(Type fromType, Type toType) {
        if (fromType instanceof Class && toType instanceof Class) {
            Class fromClass = (Class)fromType;
            Class toClass = (Class)toType;
            if (Boolean.TYPE.equals(fromClass) && Boolean.class.isAssignableFrom(toClass) || Boolean.TYPE.equals(toClass) && Boolean.class.isAssignableFrom(fromClass)) {
                return true;
            }
            if (Character.TYPE.equals(fromClass) && Character.class.isAssignableFrom(toClass) || Character.TYPE.equals(toClass) && Character.class.isAssignableFrom(fromClass)) {
                return true;
            }
            if (Integer.TYPE.equals(fromClass) && Integer.class.isAssignableFrom(toClass) || Integer.TYPE.equals(toClass) && Integer.class.isAssignableFrom(fromClass)) {
                return true;
            }
            if (Long.TYPE.equals(fromClass) && Long.class.isAssignableFrom(toClass) || Long.TYPE.equals(toClass) && Long.class.isAssignableFrom(fromClass)) {
                return true;
            }
            if (Float.TYPE.equals(fromClass) && Float.class.isAssignableFrom(toClass) || Float.TYPE.equals(toClass) && Float.class.isAssignableFrom(fromClass)) {
                return true;
            }
            if (Double.TYPE.equals(fromClass) && Double.class.isAssignableFrom(toClass) || Double.TYPE.equals(toClass) && Double.class.isAssignableFrom(fromClass)) {
                return true;
            }
            return toClass.isAssignableFrom(fromClass);
        }
        if (toType.equals(fromType)) {
            return true;
        }
        if (toType instanceof Class && fromType instanceof Class) {
            return ((Class)toType).isAssignableFrom((Class)fromType);
        }
        if (toType instanceof ParameterizedType && fromType instanceof ParameterizedType) {
            return ClazzHelper.isAssignable((ParameterizedType)toType, (ParameterizedType)fromType);
        }
        if (toType instanceof WildcardType) {
            return ClazzHelper.isAssignable((WildcardType)toType, fromType);
        }
        return false;
    }

    private static boolean isAssignable(ParameterizedType lhsType, ParameterizedType rhsType) {
        Type[] rhsTypeArguments;
        if (lhsType.equals(rhsType)) {
            return true;
        }
        Type[] lhsTypeArguments = lhsType.getActualTypeArguments();
        if (lhsTypeArguments.length != (rhsTypeArguments = rhsType.getActualTypeArguments()).length) {
            return false;
        }
        int size = lhsTypeArguments.length;
        for (int i = 0; i < size; ++i) {
            Type lhsArg = lhsTypeArguments[i];
            Type rhsArg = rhsTypeArguments[i];
            if (lhsArg.equals(rhsArg) || lhsArg instanceof WildcardType && ClazzHelper.isAssignable((WildcardType)lhsArg, rhsArg)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignable(WildcardType lhsType, Type rhsType) {
        int i;
        Type[] upperBounds = lhsType.getUpperBounds();
        Type[] lowerBounds = lhsType.getLowerBounds();
        int size = upperBounds.length;
        for (i = 0; i < size; ++i) {
            if (ClazzHelper.isAssignable(upperBounds[i], rhsType)) continue;
            return false;
        }
        size = lowerBounds.length;
        for (i = 0; i < size; ++i) {
            if (ClazzHelper.isAssignable(rhsType, lowerBounds[i])) continue;
            return false;
        }
        return true;
    }

    public static <T extends Enum<?>> T getEnumValue(Class<T> enumClass, String enumValueName) {
        Enum[] enumValues;
        for (Enum enumValue : enumValues = (Enum[])enumClass.getEnumConstants()) {
            if (!enumValueName.equalsIgnoreCase(enumValue.name())) continue;
            return (T)enumValue;
        }
        throw new JTesterException("Unable to find a enum value in enum: " + enumClass + ", with value name: " + enumValueName);
    }

    public static Type getGenericType(Field field) {
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            Type[] argumentTypes = ((ParameterizedType)type).getActualTypeArguments();
            if (argumentTypes.length == 1) {
                return argumentTypes[0];
            }
            throw new JTesterException("Unable to determine unique generic type for field: " + field + ". The field type declares more than one generic type: " + type);
        }
        throw new JTesterException("Unable to determine unique generic type for field: " + field + ". Field type is not a generic type: " + type);
    }

    public static <T> Class<T> getClassForType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        throw new JTesterException("Unable to convert Type instance " + type + " to a Class instance.");
    }

    public static byte[] getBytes(Class clazz) {
        String name = clazz.getName().replace('.', '/') + ".class";
        InputStream iStream = clazz.getClassLoader().getResourceAsStream(name);
        try {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            IOUtils.copy(iStream, (OutputStream)oStream);
            byte[] byArray = oStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly(iStream);
        }
    }

    public static <T> T newInstance(Class<T> claz) {
        if (claz.isMemberClass() && !Modifier.isStatic(claz.getModifiers())) {
            throw new JTesterException("Creation of an instance of a non-static innerclass is not possible using reflection. The type " + claz.getSimpleName() + " is only known in the context of an instance of the enclosing class " + claz.getEnclosingClass().getSimpleName() + ". Declare the innerclass as static to make construction possible.");
        }
        if (claz.isInterface()) {
            return (T)Mockit.newEmptyProxy(claz);
        }
        int modifiers = claz.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            throw new RuntimeException("unsupport abstract class!");
        }
        try {
            Constructor<T> constructor = claz.getDeclaredConstructor(new Class[0]);
            if (constructor != null) {
                boolean isAccessor = constructor.isAccessible();
                constructor.setAccessible(true);
                T o = constructor.newInstance(new Object[0]);
                constructor.setAccessible(isAccessor);
                return o;
            }
        }
        finally {
            return (T)ObjenesisHelper.newInstance(claz);
        }
        {
        }
    }

    public static final List<Field> getAllFields(Class clazz, Collection<String> filters, boolean includeStatic, boolean includeFinal, boolean includeTransient) {
        ArrayList<Field> jsonFields = new ArrayList<Field>();
        List<Field> fields = FieldHelper.getAllFields(clazz);
        for (Field field : fields) {
            String fieldname = field.getName();
            if (filters != null && filters.contains(fieldname)) continue;
            int modifier = field.getModifiers();
            if (!includeStatic && Modifier.isStatic(modifier) || !includeFinal && Modifier.isFinal(modifier) || !includeTransient && Modifier.isTransient(modifier) || jsonFields.contains(field)) continue;
            jsonFields.add(field);
        }
        return jsonFields;
    }

    public static Class getUnProxyType(Class clazz) {
        if (Proxy.isProxyClass(clazz)) {
            return Object.class;
        }
        Class type = clazz;
        while (type.isAnonymousClass() || type.getName().matches(Proxy_Type_Pattern)) {
            type = type.getSuperclass();
        }
        return type;
    }

    public static Object getProxiedObject(Object target) {
        if (ClazzHelper.isClassAvailable("org.springframework.aop.framework.Advised")) {
            Object o = SpringModuleHelper.getAdvisedObject(target);
            return o;
        }
        return target;
    }
}

