/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.bytecode.reflector.helper;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jtester.bytecode.reflector.FieldAccessor;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.exception.NoSuchFieldRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldHelper {
    public static Field getField(Class cls, String name) {
        while (cls != Object.class) {
            try {
                Field field = cls.getDeclaredField(name);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                cls = cls.getSuperclass();
            }
        }
        throw new NoSuchFieldRuntimeException("No such field: " + name);
    }

    public static void setFieldValue(Object target, String fieldName, Object fieldValue) {
        if (target == null) {
            throw new RuntimeException("the target object can't be null.");
        }
        FieldAccessor accessor = new FieldAccessor(target.getClass(), fieldName);
        accessor.set(target, fieldValue);
    }

    public static void setFieldValue(Object target, Field field, Object fieldValue) {
        if (target == null) {
            throw new RuntimeException("the target object can't be null.");
        }
        if (field == null) {
            throw new RuntimeException("the field can't be null.");
        }
        boolean isAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(target, fieldValue);
        }
        catch (Exception e) {
            String info = String.format("to set field[%s] value into target[%s] error.", field.getName(), target.getClass().getName());
            throw new RuntimeException(info, e);
        }
        finally {
            field.setAccessible(isAccessible);
        }
    }

    public static Object getFieldValue(Object target, String fieldName) {
        if (target == null) {
            throw new RuntimeException("the target object can't be null.");
        }
        FieldAccessor accessor = new FieldAccessor(target.getClass(), fieldName);
        Object o = accessor.get(target);
        return o;
    }

    public static Object getStaticFieldValue(Class claz, String fieldName) {
        if (claz == null) {
            throw new RuntimeException("the target class can't be null.");
        }
        FieldAccessor accessor = new FieldAccessor(claz, fieldName);
        Object o = accessor.getStatic();
        return o;
    }

    public static Object getFieldValue(Object target, Field field) {
        if (target == null) {
            throw new RuntimeException("the target object can't be null.");
        }
        if (field == null) {
            throw new RuntimeException("the field can't be null.");
        }
        boolean isAccessible = field.isAccessible();
        try {
            Object o;
            field.setAccessible(true);
            Object object = o = field.get(target);
            return object;
        }
        catch (Exception e) {
            String info = String.format("to get field[%s] value from target[%s] error.", field.getName(), target.getClass().getName());
            throw new RuntimeException(info, e);
        }
        finally {
            field.setAccessible(isAccessible);
        }
    }

    public static List<Field> getAllFields(Class clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        if (clazz == null || clazz.equals(Object.class)) {
            return result;
        }
        for (Class type = clazz; type != Object.class && type != null; type = type.getSuperclass()) {
            Field[] declaredFields = type.getDeclaredFields();
            result.addAll(Arrays.asList(declaredFields));
        }
        return result;
    }

    public static Set<Field> getFieldsAssignableFrom(Class clazz, Type type) {
        HashSet<Field> fieldsOfType = new HashSet<Field>();
        List<Field> allFields = FieldHelper.getAllFields(clazz);
        for (Field field : allFields) {
            boolean isAssignFrom = ClazzHelper.isAssignable(type, field.getGenericType());
            if (!isAssignFrom) continue;
            fieldsOfType.add(field);
        }
        return fieldsOfType;
    }

    public static Set<Field> getFieldsOfType(Class clazz, Type type) {
        HashSet<Field> fields = new HashSet<Field>();
        List<Field> allFields = FieldHelper.getAllFields(clazz);
        for (Field field : allFields) {
            boolean isTypeEquals = field.getType().equals(type);
            if (!isTypeEquals) continue;
            fields.add(field);
        }
        return fields;
    }
}

