/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.bytecode.reflector.helper;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.jtester.bytecode.reflector.helper.ClazzFinder;
import org.jtester.exception.JTesterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodFinder {
    public static List<String> findTestClaz(Class claz) {
        List<String> clazzes = ClazzFinder.findClazz(claz);
        String classname = claz.getName();
        List<String> tests = MethodFinder.filterClaz(clazzes, classname);
        return tests;
    }

    public static List<String> findTestClaz(String claz) {
        List<String> clazzes = ClazzFinder.findClazz(claz);
        String classname = claz.substring(claz.lastIndexOf("."));
        List<String> tests = MethodFinder.filterClaz(clazzes, classname);
        return tests;
    }

    private static List<String> filterClaz(List<String> clazzes, String classname) {
        LinkedList<String> tests = new LinkedList<String>();
        if (clazzes == null) {
            return tests;
        }
        for (String _claz : clazzes) {
            if (_claz.contains("$") || _claz.equals(classname) || !_claz.contains(classname)) continue;
            tests.add(_claz);
        }
        return tests;
    }

    public static List<String> findTestMethod(Class claz, Method method) {
        return MethodFinder.findTestMethod(claz.getName(), method.getName());
    }

    public static List<String> findTestMethod(Class claz, String methodname) {
        List<String> clazzes = MethodFinder.findTestClaz(claz);
        LinkedList<String> testmethods = new LinkedList<String>();
        for (String classname : clazzes) {
            Method[] methods;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(classname);
            }
            catch (ClassNotFoundException e) {
                throw new JTesterException(e);
            }
            for (Method method : methods = clazz.getMethods()) {
                if (method.getName().indexOf(methodname) != 0 && method.getName().indexOf("test_" + methodname) != 0) continue;
                testmethods.add(classname + "." + method.getName());
            }
        }
        return testmethods;
    }

    public static List<String> findTestMethod(String classname, String methodname) {
        try {
            Class<?> claz = Class.forName(classname);
            return MethodFinder.findTestMethod(claz, methodname);
        }
        catch (ClassNotFoundException e) {
            throw new JTesterException(e);
        }
    }
}

