/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.bytecode.reflector.helper;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jtester.bytecode.reflector.MethodAccessor;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.exception.JTesterReflectionException;
import org.jtester.exception.NoSuchMethodRuntimeException;
import org.jtester.utility.PrimitiveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodHelper {
    public static final Method getMethod(Class cls, String name, Class ... parametersType) {
        while (cls != Object.class) {
            try {
                Method[] methods;
                for (Method method : methods = cls.getDeclaredMethods()) {
                    if (!method.getName().equals(name) || !MethodHelper.matchParasType(parametersType, method.getParameterTypes())) continue;
                    method.setAccessible(true);
                    return method;
                }
                throw new NoSuchMethodException();
            }
            catch (NoSuchMethodException e) {
                cls = cls.getSuperclass();
            }
        }
        throw new NoSuchMethodRuntimeException("No such method: " + name + "(" + Arrays.toString(parametersType) + ")");
    }

    public static final List<Method> getMethod(Class cls, String name, int args) {
        ArrayList<Method> methods = new ArrayList<Method>();
        while (cls != Object.class) {
            try {
                Method[] declares;
                for (Method method : declares = cls.getDeclaredMethods()) {
                    if (!method.getName().equals(name) || method.getParameterTypes().length != args) continue;
                    methods.add(method);
                }
                throw new NoSuchMethodException();
            }
            catch (NoSuchMethodException e) {
                cls = cls.getSuperclass();
            }
        }
        return methods;
    }

    public static Set<Method> getSettersAssignableFrom(Class clazz, Type type, boolean isStatic) {
        HashSet<Method> settersAssignableFrom = new HashSet<Method>();
        Set<Method> allMethods = MethodHelper.getAllMethods(clazz);
        for (Method method : allMethods) {
            if (!MethodHelper.isSetterMethod(method) || !ClazzHelper.isAssignable(type, method.getGenericParameterTypes()[0]) || isStatic != Modifier.isStatic(method.getModifiers())) continue;
            settersAssignableFrom.add(method);
        }
        return settersAssignableFrom;
    }

    public static Set<Method> getAllMethods(Class clazz) {
        Method[] declaredMethods;
        HashSet<Method> result = new HashSet<Method>();
        if (clazz == null || clazz.equals(Object.class)) {
            return result;
        }
        for (Method declaredMethod : declaredMethods = clazz.getDeclaredMethods()) {
            if (declaredMethod.isSynthetic() || declaredMethod.isBridge()) continue;
            result.add(declaredMethod);
        }
        result.addAll(MethodHelper.getAllMethods(clazz.getSuperclass()));
        return result;
    }

    public static Set<Method> getSettersOfType(Class clazz, Type type) {
        HashSet<Method> settersOfType = new HashSet<Method>();
        Set<Method> allMethods = MethodHelper.getAllMethods(clazz);
        for (Method method : allMethods) {
            if (!MethodHelper.isSetterMethod(method) || !method.getGenericParameterTypes()[0].equals(type)) continue;
            settersOfType.add(method);
        }
        return settersOfType;
    }

    static boolean matchParasType(Class[] expecteds, Class[] actuals) {
        if (expecteds == null && actuals == null) {
            return true;
        }
        if (expecteds == null || actuals == null) {
            return false;
        }
        if (expecteds.length != actuals.length) {
            return false;
        }
        for (int index = 0; index < expecteds.length; ++index) {
            Class expected = expecteds[index];
            Class actual = actuals[index];
            if (expected == null || expected == actual || actual != null && actual.isAssignableFrom(expected) || PrimitiveHelper.isPrimitiveTypeEquals(expected, actual)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualsMethod(Method method) {
        return "equals".equals(method.getName()) && 1 == method.getParameterTypes().length && Object.class.equals(method.getParameterTypes()[0]);
    }

    public static boolean isHashCodeMethod(Method method) {
        return "hashCode".equals(method.getName()) && 0 == method.getParameterTypes().length;
    }

    public static boolean isToStringMethod(Method method) {
        return "toString".equals(method.getName()) && 0 == method.getParameterTypes().length;
    }

    public static boolean isCloneMethod(Method method) {
        return "clone".equals(method.getName()) && 0 == method.getParameterTypes().length;
    }

    public static boolean isFinalizeMethod(Method method) {
        return "finalize".equals(method.getName()) && 0 == method.getParameterTypes().length;
    }

    public static boolean isSetterMethod(Method method) {
        String methodName = method.getName();
        if (!methodName.startsWith("set") || method.getParameterTypes().length != 1 || methodName.length() < 4) {
            return false;
        }
        String fourthLetter = methodName.substring(3, 4);
        return fourthLetter.toUpperCase().equals(fourthLetter);
    }

    public static <T> T invoke(Object target, String method, Object ... paras) throws Exception {
        Class[] paraClazes = MethodHelper.getParameterClazz(paras);
        MethodAccessor accessor = new MethodAccessor(target, method, paraClazes);
        Object result = accessor.invoke(target, paras);
        return result;
    }

    public static <T> T invokeUnThrow(Object target, String method, Object ... paras) {
        Class[] paraClazes = MethodHelper.getParameterClazz(paras);
        MethodAccessor accessor = new MethodAccessor(target, method, paraClazes);
        Object result = accessor.invokeUnThrow(target, paras);
        return result;
    }

    public static Class[] getParameterClazz(Object ... paras) {
        if (paras == null) {
            return new Class[0];
        }
        ArrayList clazes = new ArrayList();
        for (Object para : paras) {
            clazes.add(para == null ? null : para.getClass());
        }
        return clazes.toArray(new Class[0]);
    }

    public static <T> T invokeStatic(Class targetClass, String method, Object ... paras) {
        ArrayList paraClazz = new ArrayList();
        if (paras != null) {
            for (Object para : paras) {
                paraClazz.add(para == null ? null : para.getClass());
            }
        }
        MethodAccessor accessor = new MethodAccessor(targetClass, method, paraClazz.toArray(new Class[0]));
        return accessor.invokeStaticUnThrow(paras);
    }

    public static <T> MethodAccessor<T> findMethodByArgCount(Class targetClazz, String methodName, int args) {
        List<Method> methods = MethodHelper.getMethod(targetClazz, methodName, args);
        if (methods.size() == 0) {
            throw new JTesterReflectionException("No such method: " + methodName + ",parameter count:" + args);
        }
        if (methods.size() > 1) {
            throw new JTesterReflectionException("More then one method: " + methodName + ",parameter count:" + args);
        }
        Method method = methods.get(0);
        return new MethodAccessor(method);
    }

    public static <T> MethodAccessor<T> findMethodByArgCount(Object target, String methodName, int args) {
        return MethodHelper.findMethodByArgCount(target.getClass(), methodName, args);
    }
}

