/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jtester.utility.ArrayHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataProviderIterator
implements Iterator<Object[]> {
    private List<Object[]> datas = new ArrayList<Object[]>();
    private Iterator<Object[]> it = null;
    private int index = 1;
    private int prev = 0;
    private String ERROR_MSG = "DataProvider error, the previous data length is %d, but current data(data index %d) %s length is %d.";

    public void data(Object ... data) {
        this.checkDataLength(data);
        this.datas.add(data);
        ++this.index;
    }

    @Override
    public boolean hasNext() {
        this.initIterator();
        return this.it.hasNext();
    }

    @Override
    public Object[] next() {
        this.initIterator();
        return this.it.next();
    }

    @Override
    public void remove() {
        this.initIterator();
        this.it.remove();
    }

    private synchronized void initIterator() {
        if (this.it == null) {
            this.it = this.datas.iterator();
        }
    }

    private void checkDataLength(Object ... data) {
        int length = data.length;
        if (length == 0) {
            throw new RuntimeException(String.format("provider data(index %d) error, can't be empty.", this.index));
        }
        if (this.prev != 0 && this.prev != length) {
            String datas = ArrayHelper.toString(data);
            String error = String.format(this.ERROR_MSG, this.prev, this.index, datas, length);
            throw new RuntimeException(error);
        }
        this.prev = length;
    }
}

